/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.actions.TypeGraphTask;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import javax.swing.tree.TreePath;

public class DisplayTypeAsGraphAction
extends DockingAction {
    private DataTypeManagerPlugin plugin;

    public DisplayTypeAsGraphAction(DataTypeManagerPlugin plugin) {
        super("Display Data Type as Graph", plugin.getName());
        this.plugin = plugin;
        String menuGroup = "ZVeryLast";
        this.setPopupMenuData(new MenuData(new String[]{"Display as Graph"}, null, menuGroup));
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Type_Graph"));
    }

    public void actionPerformed(ActionContext context) {
        TreePath[] selectionPaths;
        GraphDisplayBroker broker = (GraphDisplayBroker)this.plugin.getTool().getService(GraphDisplayBroker.class);
        if (broker == null) {
            Msg.showError((Object)((Object)this), null, (String)"Missing Plugin", (Object)"The Graph plugin is not installed.\nPlease add the plugin implementing this service.");
            return;
        }
        GraphDisplayProvider service = broker.getDefaultGraphDisplayProvider();
        GTree gTree = (GTree)context.getContextObject();
        for (TreePath path : selectionPaths = gTree.getSelectionPaths()) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (!(node instanceof DataTypeNode)) continue;
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            DataType dt = dataTypeNode.getDataType();
            if (dt instanceof TypeDef) {
                dt = ((TypeDef)dt).getBaseDataType();
            }
            if (!(dt instanceof Composite) && !(dt instanceof Pointer)) continue;
            TypeGraphTask task = new TypeGraphTask(dataTypeNode.getDataType(), service);
            new TaskLauncher((Task)task, (Component)this.plugin.getTool().getToolFrame());
        }
    }

    public boolean isEnabledForContext(ActionContext context) {
        TreePath[] selectionPaths;
        boolean enabled = false;
        if (!(context instanceof DataTypesActionContext)) {
            return enabled;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        for (TreePath path : selectionPaths = gtree.getSelectionPaths()) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (!(node instanceof DataTypeNode)) continue;
            DataTypeNode dtNode = (DataTypeNode)node;
            DataType dt = dtNode.getDataType();
            if (dt instanceof TypeDef) {
                dt = ((TypeDef)dt).getBaseDataType();
            }
            if (!(dt instanceof Composite) && !(dt instanceof Pointer)) continue;
            enabled = true;
        }
        return enabled;
    }
}

