/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.HelpLocation;

public class UpdateSourceArchiveNamesAction
extends DockingAction {
    public static final String NAME = "Update Source Archive Names";
    private final DataTypeManagerPlugin plugin;
    private final DataTypeManager dtm;

    public UpdateSourceArchiveNamesAction(DataTypeManagerPlugin plugin, DataTypeManager dtm) {
        super(NAME, plugin.getName());
        this.plugin = plugin;
        this.dtm = dtm;
        this.setPopupMenuData(new MenuData(new String[]{NAME}));
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Update_Source_Archive_Names"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        for (SourceArchive archive : this.dtm.getSourceArchives()) {
            DataTypeManager archiveDtm = handler.getDataTypeManager(archive);
            if (archiveDtm == null) continue;
            String archiveName = archiveDtm.getName();
            if (archive.getName().equals(archiveName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionContext context) {
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        int txId = this.dtm.startTransaction(NAME);
        try {
            for (SourceArchive archive : this.dtm.getSourceArchives()) {
                DataTypeManager archiveDtm = handler.getDataTypeManager(archive);
                if (archiveDtm == null) continue;
                String archiveName = archiveDtm.getName();
                if (archive.getName().equals(archiveName)) continue;
                archive.setName(archiveName);
            }
        }
        finally {
            this.dtm.endTransaction(txId, true);
        }
    }
}

