/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.DialogComponentProvider;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.app.plugin.core.function.editor.FunctionEditorDialog;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;

public class EditFunctionAction
extends ProgramContextAction {
    FunctionPlugin functionPlugin;

    EditFunctionAction(FunctionPlugin plugin) {
        super("Edit Function", plugin.getName());
        this.functionPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Edit Function..."}, null, "Function", -1, "A_Beginning"));
        this.setKeyBindingData(new KeyBindingData(70, 0));
        this.setHelpLocation(new HelpLocation("FunctionPlugin", "Edit_Function"));
    }

    @Override
    public void actionPerformed(ProgramActionContext context) {
        Function function = null;
        if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            ProgramLocation loc = listingContext.getLocation();
            if (loc instanceof FunctionLocation) {
                function = this.functionPlugin.getFunction(listingContext);
            } else if (loc instanceof OperandFieldLocation) {
                function = this.functionPlugin.getFunctionInOperandField(context.getProgram(), (OperandFieldLocation)loc);
            }
        } else {
            ProgramSymbolActionContext symbolContext = (ProgramSymbolActionContext)context;
            Symbol symbol = symbolContext.getFirstSymbol();
            if (symbol == null) {
                return;
            }
            function = (Function)symbol.getObject();
        }
        if (function != null) {
            PluginTool tool = this.functionPlugin.getTool();
            DataTypeManagerService service = (DataTypeManagerService)tool.getService(DataTypeManagerService.class);
            FunctionEditorDialog dialog = new FunctionEditorDialog(service, function);
            tool.showDialog((DialogComponentProvider)dialog, context.getComponentProvider());
        }
    }

    @Override
    protected boolean isEnabledForContext(ProgramActionContext context) {
        if (context instanceof ListingActionContext) {
            ListingActionContext listingContext = (ListingActionContext)context;
            if (listingContext.hasSelection() || listingContext.getAddress() == null) {
                return false;
            }
            ProgramLocation location = listingContext.getLocation();
            if (location instanceof FunctionLocation) {
                return true;
            }
            if (location instanceof OperandFieldLocation) {
                Function function = this.functionPlugin.getFunctionInOperandField(context.getProgram(), (OperandFieldLocation)location);
                return function != null;
            }
        } else if (context instanceof ProgramSymbolActionContext) {
            ProgramSymbolActionContext symbolContext = (ProgramSymbolActionContext)context;
            if (symbolContext.getSymbolCount() != 1) {
                return false;
            }
            Symbol s = symbolContext.getFirstSymbol();
            if (s == null || s.getSymbolType() != SymbolType.FUNCTION) {
                return false;
            }
            Function function = (Function)s.getObject();
            return function != null;
        }
        return false;
    }
}

