/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import ghidra.app.plugin.core.function.editor.ParamInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SymbolUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class FunctionDataView {
    Function function;
    String name;
    boolean hasVarArgs;
    ParamInfo returnInfo;
    List<ParamInfo> parameters = new ArrayList<ParamInfo>();
    int autoParamCount = 0;
    boolean isInLine;
    boolean hasNoReturn;
    String callingConventionName;
    boolean allowCustomStorage;
    String callFixupName;

    FunctionDataView(Function function) {
        this.function = function;
        this.name = function.getName();
        this.allowCustomStorage = function.hasCustomVariableStorage();
        this.hasVarArgs = function.hasVarArgs();
        this.isInLine = function.isInline();
        this.hasNoReturn = function.hasNoReturn();
        this.callingConventionName = function.getCallingConventionName();
        this.callFixupName = function.getCallFixup();
        this.initializeParametersAndReturn();
    }

    FunctionDataView(FunctionDataView otherFunctionData) {
        this.name = otherFunctionData.name;
        this.hasVarArgs = otherFunctionData.hasVarArgs;
        this.returnInfo = otherFunctionData.returnInfo.copy();
        for (ParamInfo p : otherFunctionData.parameters) {
            this.parameters.add(p.copy());
        }
        this.autoParamCount = otherFunctionData.autoParamCount;
        this.isInLine = otherFunctionData.isInLine;
        this.hasNoReturn = otherFunctionData.hasNoReturn;
        this.callingConventionName = otherFunctionData.callingConventionName;
        this.allowCustomStorage = otherFunctionData.allowCustomStorage;
        this.callFixupName = otherFunctionData.callFixupName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionDataView)) {
            return false;
        }
        FunctionDataView otherFunctionData = (FunctionDataView)obj;
        if (!(Objects.equals(this.name, otherFunctionData.name) && Objects.equals(this.callingConventionName, otherFunctionData.callingConventionName) && this.hasVarArgs == otherFunctionData.hasVarArgs && this.parameters.size() == otherFunctionData.parameters.size() && this.autoParamCount == otherFunctionData.autoParamCount && this.isInLine == otherFunctionData.isInLine && this.hasNoReturn == otherFunctionData.hasNoReturn && this.allowCustomStorage == otherFunctionData.allowCustomStorage && Objects.equals(this.callFixupName, otherFunctionData.callFixupName) && this.returnInfo.isSame(otherFunctionData.returnInfo))) {
            return false;
        }
        int paramCount = this.parameters.size();
        for (int i = 0; i < paramCount; ++i) {
            ParamInfo otherParam;
            ParamInfo param = this.parameters.get(i);
            if (param.isSame(otherParam = otherFunctionData.parameters.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getNameString().hashCode();
    }

    private void initializeParametersAndReturn() {
        Parameter[] params;
        this.returnInfo = new ParamInfo(this, this.function.getReturn());
        if (VoidDataType.isVoidDataType((DataType)this.returnInfo.getDataType()) && this.returnInfo.getStorage() != VariableStorage.VOID_STORAGE) {
            this.returnInfo.setStorage(VariableStorage.VOID_STORAGE);
        }
        this.autoParamCount = 0;
        for (Parameter parameter : params = this.function.getParameters()) {
            if (parameter.isAutoParameter()) {
                ++this.autoParamCount;
            }
            this.parameters.add(new ParamInfo(this, parameter));
        }
        this.fixupOrdinals();
    }

    void fixupOrdinals() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.parameters.get(i).setOrdinal(i);
        }
    }

    String getFunctionSignatureText() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.returnInfo.getFormalDataType().getName()).append(" ");
        buf.append(this.getNameString());
        buf.append(" (");
        int skipCount = this.autoParamCount;
        int ordinal = 0;
        for (ParamInfo param : this.parameters) {
            if (skipCount > 0) {
                --skipCount;
                continue;
            }
            if (ordinal++ != 0) {
                buf.append(", ");
            }
            buf.append(param.getFormalDataType().getName());
            buf.append(" ");
            buf.append(param.getName());
        }
        if (this.hasVarArgs()) {
            if (!this.parameters.isEmpty()) {
                buf.append(", ");
            }
            buf.append("...");
        } else if (this.parameters.size() == 0) {
            buf.append("void");
        }
        buf.append(')');
        return buf.toString();
    }

    public Program getProgram() {
        return this.function.getProgram();
    }

    boolean canCustomizeStorage() {
        return this.allowCustomStorage;
    }

    int getAutoParamCount() {
        return this.autoParamCount;
    }

    int getParamCount() {
        return this.parameters.size();
    }

    public String getName() {
        return this.name;
    }

    String getNameString() {
        return this.name.length() == 0 ? SymbolUtilities.getDefaultFunctionName((Address)this.function.getEntryPoint()) : this.name;
    }

    boolean isInline() {
        return this.isInLine;
    }

    boolean hasNoReturn() {
        return this.hasNoReturn;
    }

    String getCallFixupName() {
        return this.callFixupName;
    }

    boolean hasCallFixup() {
        return this.callFixupName != null;
    }

    List<ParamInfo> getParameters() {
        return this.parameters;
    }

    ParamInfo getReturnInfo() {
        return this.returnInfo;
    }

    PrototypeModel getEffectiveCallingConvention() {
        FunctionManager functionManager = this.getProgram().getFunctionManager();
        PrototypeModel effectiveCallingConvention = functionManager.getCallingConvention(this.getCallingConventionName());
        if (effectiveCallingConvention == null) {
            effectiveCallingConvention = functionManager.getDefaultCallingConvention();
        }
        return effectiveCallingConvention;
    }

    String getCallingConventionName() {
        return this.callingConventionName;
    }

    boolean hasVarArgs() {
        return this.hasVarArgs;
    }

    boolean hasParameters() {
        return !this.parameters.isEmpty();
    }
}

