/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functionwindow;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import generic.theme.GIcon;
import ghidra.app.context.FunctionSupplierContext;
import ghidra.app.plugin.core.functionwindow.FunctionRowObject;
import ghidra.app.plugin.core.functionwindow.FunctionTableModel;
import ghidra.app.plugin.core.functionwindow.FunctionWindowPlugin;
import ghidra.app.services.FunctionComparisonService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FunctionWindowProvider
extends ComponentProviderAdapter {
    public static final Icon ICON = new GIcon("icon.plugin.functionwindow.provider");
    private static final Icon COMPARISON_ICON = new GIcon("icon.plugin.functioncompare.new");
    private FunctionWindowPlugin plugin;
    private GhidraTable functionTable;
    private FunctionTableModel functionModel;
    private JComponent mainPanel;
    private GhidraTableFilterPanel<FunctionRowObject> tableFilterPanel;
    private GhidraThreadedTablePanel<FunctionRowObject> threadedTablePanel;
    private DockingAction compareAction;

    FunctionWindowProvider(FunctionWindowPlugin plugin) {
        super(plugin.getTool(), "Functions Window", plugin.getName());
        this.setTitle("Functions");
        this.plugin = plugin;
        this.setIcon(ICON);
        this.setHelpLocation(new HelpLocation(plugin.getName(), plugin.getName()));
        this.tool = plugin.getTool();
        this.mainPanel = this.createWorkPanel();
        this.tool.addComponentProvider((ComponentProvider)this, false);
        this.createActions();
    }

    private void createActions() {
        this.addLocalAction((DockingActionIf)new SelectionNavigationAction(this.plugin.getName(), this.getTable()));
        this.addLocalAction((DockingActionIf)new MakeProgramSelectionAction(this.plugin, this.getTable()));
    }

    void createCompareAction() {
        this.compareAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Compare Functions", this.plugin.getName()).description("Create Function Comparison")).helpLocation(new HelpLocation("FunctionComparison", "Function_Comparison"))).toolBarIcon(COMPARISON_ICON)).toolBarGroup("Comparison")).enabledWhen(c -> this.functionTable.getSelectedRowCount() > 1)).onAction(c -> this.compareSelectedFunctions())).buildAndInstallLocal((ComponentProvider)this);
    }

    void removeCompareAction() {
        this.tool.removeLocalAction((ComponentProvider)this, (DockingActionIf)this.compareAction);
    }

    private void compareSelectedFunctions() {
        HashSet<Function> functions = new HashSet<Function>();
        int[] selectedRows = this.functionTable.getSelectedRows();
        List functionRowObjects = this.functionModel.getRowObjects(selectedRows);
        for (FunctionRowObject functionRowObject : functionRowObjects) {
            Function rowFunction = functionRowObject.getFunction();
            functions.add(rowFunction);
        }
        FunctionComparisonService service = (FunctionComparisonService)this.getTool().getService(FunctionComparisonService.class);
        service.createComparison(functions);
    }

    public void componentHidden() {
        this.functionModel.reload(null);
    }

    public void componentShown() {
        this.functionModel.reload(this.plugin.getProgram());
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new FunctionWindowActionContext();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    void programOpened(Program program) {
        if (this.isVisible()) {
            this.functionModel.reload(program);
        }
    }

    void programClosed() {
        this.functionModel.reload(null);
    }

    void showFunctions() {
        this.tool.showComponentProvider((ComponentProvider)this, true);
    }

    void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this);
        this.threadedTablePanel.dispose();
        this.tableFilterPanel.dispose();
    }

    void reload() {
        if (this.isVisible()) {
            this.functionModel.reload(this.plugin.getProgram());
        }
    }

    private JComponent createWorkPanel() {
        this.functionModel = new FunctionTableModel(this.plugin.getTool(), null);
        this.threadedTablePanel = new GhidraThreadedTablePanel<FunctionRowObject>(this.functionModel, 1000);
        this.functionTable = this.threadedTablePanel.getTable();
        this.functionTable.installNavigation((ServiceProvider)this.tool);
        this.functionTable.setAutoLookupColumn(0);
        this.functionTable.setAutoResizeMode(2);
        this.functionTable.setPreferredScrollableViewportSize(new Dimension(350, 150));
        this.functionTable.setRowSelectionAllowed(true);
        this.functionTable.setSelectionMode(2);
        this.functionTable.getSelectionModel().addListSelectionListener(e -> this.tool.contextChanged((ComponentProvider)this));
        this.functionModel.addTableModelListener(e -> {
            int rowCount = this.functionModel.getRowCount();
            int unfilteredCount = this.functionModel.getUnfilteredRowCount();
            StringBuilder buffy = new StringBuilder();
            buffy.append(rowCount).append(" items");
            if (rowCount != unfilteredCount) {
                buffy.append(" (of ").append(unfilteredCount).append(" )");
            }
            this.setSubTitle(buffy.toString());
        });
        JTableHeader functionHeader = this.functionTable.getTableHeader();
        functionHeader.setUpdateTableInRealTime(true);
        this.setFunctionTableRenderer();
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.functionTable), this.functionModel);
        String namePrefix = "Functions";
        this.functionTable.setAccessibleNamePrefix(namePrefix);
        this.tableFilterPanel.setAccessibleNamePrefix(namePrefix);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)((Object)this.threadedTablePanel), "Center");
        container.add((Component)((Object)this.tableFilterPanel), "South");
        return container;
    }

    private void setFunctionTableRenderer() {
        TableColumnModel columnModel = this.functionTable.getColumnModel();
        TableColumn column = columnModel.getColumn(1);
        column.setPreferredWidth(50);
    }

    void update(Function function) {
        if (!this.isVisible()) {
            return;
        }
        Set<Function> functions = this.getRelatedFunctions(function);
        for (Function f : functions) {
            this.functionModel.update(f);
        }
    }

    private Set<Function> getRelatedFunctions(Function f) {
        Program program = f.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        HashSet<Function> functions = new HashSet<Function>();
        Address[] addresses = f.getFunctionThunkAddresses(true);
        if (addresses != null) {
            for (Address a : addresses) {
                Function thunk = functionManager.getFunctionAt(a);
                if (thunk == null) continue;
                functions.add(thunk);
            }
        }
        functions.add(f);
        return functions;
    }

    void functionAdded(Function function) {
        if (this.isVisible()) {
            this.functionModel.functionAdded(function);
        }
    }

    void functionRemoved(Function function) {
        if (this.isVisible()) {
            this.functionModel.functionRemoved(function);
        }
    }

    GhidraTable getTable() {
        return this.functionTable;
    }

    FunctionTableModel getModel() {
        return this.functionModel;
    }

    public String getWindowSubMenuName() {
        return null;
    }

    public boolean isTransient() {
        return false;
    }

    private class FunctionWindowActionContext
    extends DefaultActionContext
    implements FunctionSupplierContext {
        FunctionWindowActionContext() {
            super((ComponentProvider)FunctionWindowProvider.this, (Component)((Object)FunctionWindowProvider.this.functionTable));
        }

        @Override
        public boolean hasFunctions() {
            return FunctionWindowProvider.this.functionTable.getSelectedRowCount() > 0;
        }

        @Override
        public Set<Function> getFunctions() {
            HashSet<Function> functions = new HashSet<Function>();
            int[] selectedRows = FunctionWindowProvider.this.functionTable.getSelectedRows();
            if (selectedRows.length == 0) {
                return Collections.emptySet();
            }
            List functionRowObjects = FunctionWindowProvider.this.functionModel.getRowObjects(selectedRows);
            for (FunctionRowObject functionRowObject : functionRowObjects) {
                Function rowFunction = functionRowObject.getFunction();
                functions.add(rowFunction);
            }
            return functions;
        }
    }
}

