/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.interpreter;

import docking.widgets.list.GListCellRenderer;
import ghidra.app.plugin.core.console.CodeCompletion;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class CodeCompletionListCellRenderer
extends GListCellRenderer<CodeCompletion> {
    CodeCompletionListCellRenderer() {
    }

    protected String getItemText(CodeCompletion value) {
        return value.getDescription();
    }

    public Component getListCellRendererComponent(JList<? extends CodeCompletion> list, CodeCompletion codeCompletion, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel component = (JLabel)super.getListCellRendererComponent(list, (Object)codeCompletion, index, isSelected, cellHasFocus);
        component.setOpaque(true);
        if (isSelected) {
            component.setBackground(list.getSelectionBackground());
        } else {
            component.setBackground(list.getBackground());
        }
        component.setEnabled(list.isEnabled());
        component.setFont(list.getFont());
        component.setComponentOrientation(list.getComponentOrientation());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = new EmptyBorder(1, 1, 1, 1);
        }
        component.setBorder(border);
        return component;
    }
}

