/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import ghidra.framework.cmd.Command;
import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Program;

class SetBaseCommand
implements Command<Program> {
    private Address addr;
    private String msg;

    SetBaseCommand(Address addr) {
        this.addr = addr;
    }

    public boolean applyTo(Program program) {
        try {
            program.setImageBase(this.addr, true);
        }
        catch (IllegalStateException e) {
            this.msg = e.getMessage();
            return false;
        }
        catch (AddressOverflowException e) {
            this.msg = "Image base of " + this.addr.toString() + " not allowed; change causes " + e.getMessage();
            return false;
        }
        catch (LockException e) {
            this.msg = "Must have exclusive checkout to set the image base";
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.msg;
    }

    public String getName() {
        return "Set Image Base";
    }
}

