/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reachability;

import docking.ComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.widgets.label.GDLabel;
import ghidra.app.plugin.core.reachability.FRPathsModel;
import ghidra.app.plugin.core.reachability.FRVertex;
import ghidra.app.plugin.core.reachability.FunctionReachabilityPlugin;
import ghidra.app.plugin.core.reachability.FunctionReachabilityResult;
import ghidra.app.plugin.core.reachability.FunctionReachabilityTableModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableModel;

public class FunctionReachabilityProvider
extends ComponentProvider {
    private static final String TITLE = "Function Reachability";
    private FunctionReachabilityPlugin plugin;
    private Program program;
    private Function fromFunction;
    private Function toFunction;
    private JComponent component;
    private JTextField fromAddressField;
    private JLabel fromFunctionLabel;
    private JTextField toAddressField;
    private JLabel toFunctionLabel;
    private FunctionReachabilityTableModel resultsModel;
    private GhidraTable resultsTable;
    private FRPathsModel pathsModel;
    private GhidraTable pathsTable;

    public FunctionReachabilityProvider(FunctionReachabilityPlugin plugin) {
        super((Tool)plugin.getTool(), TITLE, plugin.getName());
        this.plugin = plugin;
        this.component = this.buildComponent();
        this.component.setPreferredSize(new Dimension(800, 400));
        this.setTransient();
        this.setWindowMenuGroup(TITLE);
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setIcon(FunctionReachabilityPlugin.ICON);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Function_Reachability_Plugin"));
        this.addToTool();
        this.createActions();
    }

    private void createActions() {
    }

    private JComponent buildComponent() {
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 3));
        this.fromAddressField = new JTextField(15);
        this.fromFunctionLabel = new GDLabel();
        JButton swapButton = new JButton("Swap");
        swapButton.addActionListener(e -> {
            String fromText = this.fromAddressField.getText();
            String toText = this.toAddressField.getText();
            this.fromAddressField.setText(toText);
            this.toAddressField.setText(fromText);
        });
        this.toAddressField = new JTextField(15);
        this.toFunctionLabel = new GDLabel();
        JButton goButton = new JButton("Go");
        goButton.addActionListener(e -> this.findPaths());
        inputPanel.add(this.fromAddressField);
        inputPanel.add(this.fromFunctionLabel);
        inputPanel.add(Box.createVerticalStrut(20));
        inputPanel.add(swapButton);
        inputPanel.add(Box.createVerticalStrut(20));
        inputPanel.add(this.toAddressField);
        inputPanel.add(this.toFunctionLabel);
        inputPanel.add(Box.createVerticalStrut(30));
        inputPanel.add(goButton);
        JPanel outputPanel = new JPanel(new GridLayout(1, 2));
        this.resultsModel = new FunctionReachabilityTableModel((ServiceProvider)this.plugin.getTool(), this.program);
        GhidraThreadedTablePanel<FunctionReachabilityResult> tablePanel = new GhidraThreadedTablePanel<FunctionReachabilityResult>(this.resultsModel);
        this.resultsTable = tablePanel.getTable();
        this.resultsTable.installNavigation((ServiceProvider)this.plugin.getTool());
        this.resultsTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int[] selectedRows = this.resultsTable.getSelectedRows();
            if (selectedRows.length != 1) {
                List<FRVertex> emptyList = Collections.emptyList();
                this.pathsModel.setPath(emptyList);
                return;
            }
            FunctionReachabilityResult result = (FunctionReachabilityResult)this.resultsModel.getRowObject(selectedRows[0]);
            this.pathsModel.setPath(result.getPath());
        });
        outputPanel.add((Component)((Object)tablePanel));
        this.pathsModel = new FRPathsModel((ServiceProvider)this.plugin.getTool(), this.program);
        this.pathsTable = new GhidraTable((TableModel)((Object)this.pathsModel));
        this.pathsTable.installNavigation((ServiceProvider)this.plugin.getTool());
        outputPanel.add(new JScrollPane((Component)((Object)this.pathsTable)));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)inputPanel, "West");
        panel.add((Component)outputPanel, "Center");
        return panel;
    }

    private void findPaths() {
        if (!this.validateFunctions()) {
            return;
        }
        this.resultsModel.setFunctions(this.fromFunction, this.toFunction);
    }

    private boolean validateFunctions() {
        PluginTool tool = this.plugin.getTool();
        String text = this.fromAddressField.getText();
        if (this.isNumpty(text)) {
            tool.setStatusInfo("Must input two valid functions: 'from' address is empty", true);
            return false;
        }
        this.fromFunction = this.getFunction(text);
        if (this.fromFunction == null) {
            this.fromFunctionLabel.setText("");
            tool.setStatusInfo("Must input two valid functions: 'from' address is not in a function: " + text, true);
            return false;
        }
        this.fromFunctionLabel.setText(this.fromFunction.getName());
        text = this.toAddressField.getText();
        if (this.isNumpty(text)) {
            tool.setStatusInfo("Must input two valid functions: 'to' address is empty", true);
            return false;
        }
        this.toFunction = this.getFunction(text);
        if (this.toFunction == null) {
            this.toFunctionLabel.setText("");
            tool.setStatusInfo("Must input two valid functions: 'to' address is not in a function: " + text, true);
            return false;
        }
        this.toFunctionLabel.setText(this.toFunction.getName());
        return true;
    }

    private Function getFunction(String addressString) {
        FunctionManager functionManager = this.program.getFunctionManager();
        AddressFactory factory = this.program.getAddressFactory();
        Address address = factory.getAddress(addressString);
        if (address == null) {
            return null;
        }
        return functionManager.getFunctionContaining(address);
    }

    private boolean isNumpty(String text) {
        return text == null || text.isEmpty();
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void componentHidden() {
        this.plugin.removeProvider(this);
    }

    void initialize(Program p, ProgramLocation location) {
        if (p == null) {
            return;
        }
        this.program = p;
        this.resultsModel.setProgram(p);
        this.pathsModel.setProgram(p);
        this.doSetLocation(location);
    }

    private void doSetLocation(ProgramLocation location) {
        if (location == null) {
            return;
        }
        FunctionManager functionManager = this.program.getFunctionManager();
        Address address = location.getAddress();
        Function function = functionManager.getFunctionContaining(address);
        this.setFromFunction(function);
    }

    private void setFromFunction(Function function) {
        this.fromFunction = function;
        Address address = null;
        String functionText = "";
        if (this.fromFunction != null) {
            address = this.fromFunction.getEntryPoint();
            functionText = function.getName();
        }
        String addressText = address == null ? "" : address.toString();
        this.fromAddressField.setText(addressText);
        this.fromFunctionLabel.setText(functionText);
    }
}

