/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.register;

import ghidra.app.plugin.core.register.RegisterTreeGroupNode;
import ghidra.app.plugin.core.register.RegisterTreeNode;
import ghidra.app.plugin.core.register.SearchableRegisterTreeNode;
import ghidra.program.model.lang.Register;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.Icon;

class RegisterTreeRootNode
extends SearchableRegisterTreeNode {
    private Register[] lastRegisters;

    RegisterTreeRootNode() {
    }

    public Icon getIcon(boolean expanded) {
        return null;
    }

    public String getName() {
        return "Registers";
    }

    public String getToolTip() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }

    public void setRegisters(Register[] registers) {
        if (registers == this.lastRegisters) {
            return;
        }
        this.removeAll();
        this.lastRegisters = registers;
        HashMap<String, RegisterTreeGroupNode> groups = new HashMap<String, RegisterTreeGroupNode>();
        ArrayList<SearchableRegisterTreeNode> nodes = new ArrayList<SearchableRegisterTreeNode>();
        for (Register register : registers) {
            if (register.getBaseRegister() != register && !register.getParentRegister().isHidden()) continue;
            String groupName = register.getGroup();
            if (groupName != null) {
                RegisterTreeGroupNode group = (RegisterTreeGroupNode)((Object)groups.get(groupName));
                if (group == null) {
                    group = new RegisterTreeGroupNode(groupName);
                    groups.put(groupName, group);
                    nodes.add(group);
                }
                group.addRegister(register);
                continue;
            }
            nodes.add(new RegisterTreeNode(register));
        }
        Collections.sort(nodes);
        this.setChildren(nodes);
    }
}

