/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext.databasesearcher;

import ghidra.app.plugin.core.searchtext.Searcher;
import ghidra.app.plugin.core.searchtext.databasesearcher.ProgramDatabaseFieldSearcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataMnemonicOperandFieldSearcher
extends ProgramDatabaseFieldSearcher {
    private DataIterator iterator;
    private CodeUnitFormat format;
    private final boolean doMnemonics;
    private final boolean doOperands;
    private Program program;

    static DataMnemonicOperandFieldSearcher createDataMnemonicOnlyFieldSearcher(Program program, ProgramLocation startLoc, AddressSetView set, boolean forward, Pattern pattern, CodeUnitFormat format) {
        return new DataMnemonicOperandFieldSearcher(program, startLoc, set, forward, pattern, format, true, false);
    }

    static DataMnemonicOperandFieldSearcher createDataOperandOnlyFieldSearcher(Program program, ProgramLocation startLoc, AddressSetView set, boolean forward, Pattern pattern, CodeUnitFormat format) {
        return new DataMnemonicOperandFieldSearcher(program, startLoc, set, forward, pattern, format, false, true);
    }

    static DataMnemonicOperandFieldSearcher createDataMnemonicAndOperandFieldSearcher(Program program, ProgramLocation startLoc, AddressSetView set, boolean forward, Pattern pattern, CodeUnitFormat format) {
        return new DataMnemonicOperandFieldSearcher(program, startLoc, set, forward, pattern, format, true, true);
    }

    private DataMnemonicOperandFieldSearcher(Program program, ProgramLocation startLoc, AddressSetView set, boolean forward, Pattern pattern, CodeUnitFormat format, boolean doMnemonics, boolean doOperands) {
        super(pattern, forward, startLoc, set);
        this.program = program;
        this.format = format;
        this.doMnemonics = doMnemonics;
        this.doOperands = doOperands;
        this.iterator = set != null ? program.getListing().getDefinedData(set, forward) : program.getListing().getDefinedData(startLoc.getAddress(), forward);
    }

    @Override
    protected Address advance(List<Searcher.TextSearchResult> currentMatches) {
        Data data = this.iterator.next();
        Address nextAddress = null;
        if (data != null) {
            nextAddress = data.getMinAddress();
            this.findMatchesForCurrentAddress(data, currentMatches);
        }
        return nextAddress;
    }

    private void findMatchesForCurrentAddress(Data data, List<Searcher.TextSearchResult> currentMatches) {
        Object value;
        StringBuffer searchStrBuf = new StringBuffer();
        String mnemonicString = "";
        String operandString = "";
        if (this.doMnemonics) {
            mnemonicString = data.getMnemonicString();
            searchStrBuf.append(mnemonicString);
        }
        if (this.doOperands && (value = data.getValue()) != null) {
            operandString = this.format.getDataValueRepresentationString(data);
            if (searchStrBuf.length() != 0) {
                searchStrBuf.append(' ');
            }
            searchStrBuf.append(operandString);
        }
        Matcher matcher = this.pattern.matcher(searchStrBuf.toString());
        Address address = data.getMinAddress();
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex == mnemonicString.length() && this.doMnemonics) continue;
            if (startIndex < mnemonicString.length()) {
                this.addMnemonicMatch(currentMatches, mnemonicString, address, startIndex, endIndex);
                continue;
            }
            this.addOperandMatch(data, currentMatches, mnemonicString, operandString, address, startIndex);
        }
    }

    private void addOperandMatch(Data data, List<Searcher.TextSearchResult> currentMatches, String mnemonicString, String operandString, Address address, int index) {
        if (!this.doOperands) {
            return;
        }
        currentMatches.add(new Searcher.TextSearchResult((ProgramLocation)new OperandFieldLocation(this.program, address, data.getComponentPath(), null, operandString, 0, index - mnemonicString.length() - 1), index));
    }

    private void addMnemonicMatch(List<Searcher.TextSearchResult> currentMatches, String mnemonicString, Address address, int index, int endIndex) {
        if (!this.doMnemonics) {
            return;
        }
        if (endIndex > mnemonicString.length()) {
            return;
        }
        currentMatches.add(new Searcher.TextSearchResult((ProgramLocation)new MnemonicFieldLocation(this.program, address, null, null, mnemonicString, index), index));
    }
}

