/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.sourcefilestable;

import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.SourceFileIdType;
import ghidra.program.model.sourcemap.SourceFileManager;

public class SourceFileRowObject {
    private SourceFile sourceFile;
    private int numEntries;

    public SourceFileRowObject(SourceFile sourceFile, SourceFileManager sourceManager) {
        this.sourceFile = sourceFile;
        this.numEntries = sourceManager.getSourceMapEntries(sourceFile).size();
    }

    public String getFileName() {
        return this.sourceFile.getFilename();
    }

    public String getPath() {
        return this.sourceFile.getPath();
    }

    public int getNumSourceMapEntries() {
        return this.numEntries;
    }

    public SourceFile getSourceFile() {
        return this.sourceFile;
    }

    public SourceFileIdType getSourceFileIdType() {
        return this.sourceFile.getIdType();
    }
}

