/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable.dnd;

import ghidra.app.plugin.core.symtable.dnd.SymbolDataFlavor;
import ghidra.app.plugin.core.symtable.dnd.SymbolTransferData;
import ghidra.program.model.symbol.Symbol;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class SymbolTransferable
implements Transferable {
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{SymbolDataFlavor.DATA_FLAVOR};
    private List<Symbol> symbols;
    private Component source;

    public SymbolTransferable(Component source, List<Symbol> symbols) {
        this.source = Objects.requireNonNull(source);
        this.symbols = Objects.requireNonNull(symbols);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!SymbolDataFlavor.DATA_FLAVOR.equals(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return new SymbolTransferData(this.source, this.symbols);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor f : FLAVORS) {
            if (!f.equals(flavor)) continue;
            return true;
        }
        return false;
    }
}

