/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import docking.ActionContext;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import java.awt.Point;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import resources.Icons;

public class DomainFolderChangesDisplayComponentProvider
extends ComponentProviderAdapter {
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JViewport viewport;
    private Point bottom = new Point(0, 10000);
    private DockingAction clearAction;

    public DomainFolderChangesDisplayComponentProvider(PluginTool tool, String owner) {
        super(tool, "Domain Folder Changes", owner);
        this.textArea = new JTextArea(10, 80);
        this.textArea.setEditable(true);
        this.scrollPane = new JScrollPane(this.textArea);
        this.viewport = this.scrollPane.getViewport();
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setTitle("Domain Folder Changes Display");
        this.setVisible(true);
        this.createAction();
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void addText(String text) {
        String date = new Date().toString();
        text = date + "     " + (String)text;
        Msg.debug((Object)((Object)this), (Object)text);
        this.textArea.append((String)text);
        this.textArea.append("\n");
        this.viewport.setViewPosition(this.bottom);
    }

    private void createAction() {
        this.clearAction = new DockingAction("Clear Display", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                DomainFolderChangesDisplayComponentProvider.this.clear();
            }
        };
        this.clearAction.setEnabled(true);
        Icon icon = Icons.CLEAR_ICON;
        this.clearAction.setToolBarData(new ToolBarData(icon));
        this.addLocalAction((DockingActionIf)this.clearAction);
    }

    private void clear() {
        this.textArea.setText("");
    }
}

