/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.match;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import java.util.ArrayList;

public class Match
implements Comparable<Match> {
    private Address thisBeginning;
    private Address otherBeginning;
    private ArrayList<Object> thisMatch;
    private ArrayList<Object> otherMatch;
    private int totalLength;

    public Match(Address thisBeginning, Address otherBeginning, byte[] bytes, int length) {
        this.thisBeginning = thisBeginning;
        this.otherBeginning = otherBeginning;
        this.thisMatch = new ArrayList();
        this.otherMatch = this.thisMatch;
        for (int i = 0; i < length; ++i) {
            String str = bytes[i] < 0 ? Long.toHexString(bytes[i] + 256) : Long.toHexString(bytes[i]);
            this.thisMatch.add(i, str);
            ++this.totalLength;
        }
    }

    public Match(Address thisBeginning, Address otherBeginning, CodeUnit[] codeUnits, CodeUnit[] otherUnits, int length) {
        this.thisBeginning = thisBeginning;
        this.otherBeginning = otherBeginning;
        this.thisMatch = new ArrayList();
        this.otherMatch = new ArrayList();
        for (int i = 0; i < length; ++i) {
            this.thisMatch.add(i, codeUnits[i]);
            this.otherMatch.add(i, otherUnits[i]);
            this.totalLength += codeUnits[i].getLength();
        }
    }

    public void continueMatch(byte b) {
        String str = b < 0 ? Long.toHexString(b + 256) : Long.toHexString(b);
        this.thisMatch.add(str);
        ++this.totalLength;
    }

    public void continueMatch(CodeUnit cu, CodeUnit otherUnit) {
        this.thisMatch.add(cu);
        this.otherMatch.add(otherUnit);
        this.totalLength += cu.getLength();
    }

    public int length() {
        return this.thisMatch.size();
    }

    public int totalLength() {
        return this.totalLength;
    }

    public String toString() {
        String str = this.otherBeginning.toString(true) + "\n";
        for (int i = 0; i < this.thisMatch.size(); ++i) {
            str = str + this.thisMatch.get(i).toString() + " ";
        }
        return str;
    }

    public Address getOtherBeginning() {
        return this.otherBeginning;
    }

    public Address getThisBeginning() {
        return this.thisBeginning;
    }

    public Object[] getBytes() {
        return this.thisMatch.toArray(new Object[0]);
    }

    public Object[] getOtherBytes() {
        return this.otherMatch.toArray(new Object[0]);
    }

    public String printMatch() {
        String str = "1.00 " + this.length() + " " + this.length() + this.thisBeginning.toString(true) + " " + Long.toHexString(this.thisBeginning.getOffset()) + this.otherBeginning.toString(true) + " " + Long.toHexString(this.otherBeginning.getOffset()) + "\n";
        return str;
    }

    @Override
    public int compareTo(Match m) {
        int val = this.getThisBeginning().compareTo((Object)m.getThisBeginning());
        if (val != 0) {
            return val;
        }
        val = this.getOtherBeginning().compareTo((Object)m.getOtherBeginning());
        if (val != 0) {
            return val;
        }
        return this.length() - m.length();
    }

    public Address expectedAddressForNextMatch(int baseLength) {
        Object o = this.thisMatch.get(this.length() - baseLength + 1);
        if (o instanceof CodeUnit) {
            CodeUnit cu = (CodeUnit)this.thisMatch.get(this.length() - baseLength + 1);
            return cu.getMinAddress();
        }
        return this.thisBeginning.add((long)(this.totalLength() - baseLength + 1));
    }
}

