/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.sectionprovider;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.dwarf.sectionprovider.DWARFSectionProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class BaseSectionProvider
implements DWARFSectionProvider {
    protected Program program;
    protected List<String> sectionPrefixes = this.getSectionPrefixSearchList();

    public static BaseSectionProvider createSectionProviderFor(Program program, TaskMonitor monitor) {
        return new BaseSectionProvider(program);
    }

    public BaseSectionProvider(Program program) {
        this.program = program;
    }

    protected List<String> getSectionPrefixSearchList() {
        return List.of(".", "_", "__");
    }

    @Override
    public ByteProvider getSectionAsByteProvider(String sectionName, TaskMonitor monitor) throws IOException {
        MemoryBlock block = this.getSection(sectionName);
        if (block != null && block.isInitialized()) {
            return MemoryByteProvider.createMemoryBlockByteProvider(this.program.getMemory(), block);
        }
        return null;
    }

    @Override
    public boolean hasSection(String ... sectionNames) {
        for (String sectionName : sectionNames) {
            if (this.getSection(sectionName) != null) continue;
            return false;
        }
        return true;
    }

    protected MemoryBlock getSection(String sectionName) {
        MemoryBlock block = this.program.getMemory().getBlock(sectionName);
        if (block == null) {
            for (String prefix : this.sectionPrefixes) {
                block = this.program.getMemory().getBlock(prefix + sectionName);
                if (block == null) continue;
                break;
            }
        }
        return block;
    }

    @Override
    public void close() {
    }
}

