/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.StringUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.util.HashMap;
import java.util.Map;

public class ElfSectionHeaderType {
    private static Map<Integer, ElfSectionHeaderType> defaultElfSectionHeaderTypeMap = new HashMap<Integer, ElfSectionHeaderType>();
    public static ElfSectionHeaderType SHT_NULL = ElfSectionHeaderType.addDefaultSectionHeaderType(0, "SHT_NULL", "Inactive section header");
    public static ElfSectionHeaderType SHT_PROGBITS = ElfSectionHeaderType.addDefaultSectionHeaderType(1, "SHT_PROGBITS", "Program defined section");
    public static ElfSectionHeaderType SHT_SYMTAB = ElfSectionHeaderType.addDefaultSectionHeaderType(2, "SHT_SYMTAB", "Symbol table for link editing and dynamic linking");
    public static ElfSectionHeaderType SHT_STRTAB = ElfSectionHeaderType.addDefaultSectionHeaderType(3, "SHT_STRTAB", "String table");
    public static ElfSectionHeaderType SHT_RELA = ElfSectionHeaderType.addDefaultSectionHeaderType(4, "SHT_RELA", "Relocation entries with explicit addends");
    public static ElfSectionHeaderType SHT_HASH = ElfSectionHeaderType.addDefaultSectionHeaderType(5, "SHT_HASH", "Symbol hash table for dynamic linking");
    public static ElfSectionHeaderType SHT_DYNAMIC = ElfSectionHeaderType.addDefaultSectionHeaderType(6, "SHT_DYNAMIC", "Dynamic linking information");
    public static ElfSectionHeaderType SHT_NOTE = ElfSectionHeaderType.addDefaultSectionHeaderType(7, "SHT_NOTE", "Section holds information that marks the file");
    public static ElfSectionHeaderType SHT_NOBITS = ElfSectionHeaderType.addDefaultSectionHeaderType(8, "SHT_NOBITS", "Section contains no bytes");
    public static ElfSectionHeaderType SHT_REL = ElfSectionHeaderType.addDefaultSectionHeaderType(9, "SHT_REL", "Relocation entries w/o explicit addends");
    public static ElfSectionHeaderType SHT_SHLIB = ElfSectionHeaderType.addDefaultSectionHeaderType(10, "SHT_SHLIB", "");
    public static ElfSectionHeaderType SHT_DYNSYM = ElfSectionHeaderType.addDefaultSectionHeaderType(11, "SHT_DYNSYM", "Symbol table for dynamic linking");
    public static ElfSectionHeaderType SHT_INIT_ARRAY = ElfSectionHeaderType.addDefaultSectionHeaderType(14, "SHT_INIT_ARRAY", "Array of initializer functions");
    public static ElfSectionHeaderType SHT_FINI_ARRAY = ElfSectionHeaderType.addDefaultSectionHeaderType(15, "SHT_FINI_ARRAY", "Array of finalizer functions");
    public static ElfSectionHeaderType SHT_PREINIT_ARRAY = ElfSectionHeaderType.addDefaultSectionHeaderType(16, "SHT_PREINIT_ARRAY", "Array of pre-initializer functions");
    public static ElfSectionHeaderType SHT_GROUP = ElfSectionHeaderType.addDefaultSectionHeaderType(17, "SHT_GROUP", "Section group");
    public static ElfSectionHeaderType SHT_SYMTAB_SHNDX = ElfSectionHeaderType.addDefaultSectionHeaderType(18, "SHT_SYMTAB_SHNDX", "Extended section indeces");
    public static ElfSectionHeaderType SHT_ANDROID_REL = ElfSectionHeaderType.addDefaultSectionHeaderType(0x60000001, "SHT_ANDROID_REL", "Android relocation entries w/o explicit addends");
    public static ElfSectionHeaderType SHT_ANDROID_RELA = ElfSectionHeaderType.addDefaultSectionHeaderType(0x60000002, "SHT_ANDROID_RELA", "Android relocation entries with explicit addends");
    public static ElfSectionHeaderType SHT_GNU_ATTRIBUTES = ElfSectionHeaderType.addDefaultSectionHeaderType(0x6FFFFFF5, "SHT_GNU_ATTRIBUTES", "Object attributes");
    public static ElfSectionHeaderType SHT_GNU_HASH = ElfSectionHeaderType.addDefaultSectionHeaderType(0x6FFFFFF6, "SHT_GNU_HASH", "GNU-style hash table");
    public static ElfSectionHeaderType SHT_GNU_LIBLIST = ElfSectionHeaderType.addDefaultSectionHeaderType(0x6FFFFFF7, "SHT_GNU_LIBLIST", "Prelink library list");
    public static ElfSectionHeaderType SHT_CHECKSUM = ElfSectionHeaderType.addDefaultSectionHeaderType(0x6FFFFFF8, "SHT_CHECKSUM", "Checksum for DSO content");
    public static ElfSectionHeaderType SHT_SUNW_move = ElfSectionHeaderType.addDefaultSectionHeaderType(0x6FFFFFFA, "SHT_SUNW_move", "");
    public static ElfSectionHeaderType SHT_SUNW_COMDAT = ElfSectionHeaderType.addDefaultSectionHeaderType(0x6FFFFFFB, "SHT_SUNW_COMDAT", "");
    public static ElfSectionHeaderType SHT_SUNW_syminfo = ElfSectionHeaderType.addDefaultSectionHeaderType(0x6FFFFFFC, "SHT_SUNW_syminfo", "");
    public static ElfSectionHeaderType SHT_GNU_verdef = ElfSectionHeaderType.addDefaultSectionHeaderType(0x6FFFFFFD, "SHT_GNU_verdef", "Version definition section");
    public static ElfSectionHeaderType SHT_GNU_verneed = ElfSectionHeaderType.addDefaultSectionHeaderType(0x6FFFFFFE, "SHT_GNU_verneed", "Version needs section");
    public static ElfSectionHeaderType SHT_GNU_versym = ElfSectionHeaderType.addDefaultSectionHeaderType(0x6FFFFFFF, "SHT_GNU_versym", "Version symbol table");
    public final int value;
    public final String name;
    public final String description;

    private static ElfSectionHeaderType addDefaultSectionHeaderType(int value, String name, String description) {
        try {
            ElfSectionHeaderType type = new ElfSectionHeaderType(value, name, description);
            ElfSectionHeaderType.addSectionHeaderType(type, defaultElfSectionHeaderTypeMap);
            return type;
        }
        catch (DuplicateNameException e) {
            throw new RuntimeException("ElfSectionHeaderType initialization error", e);
        }
    }

    public static void addSectionHeaderType(ElfSectionHeaderType type, Map<Integer, ElfSectionHeaderType> sectionHeaderTypeMap) throws DuplicateNameException {
        ElfSectionHeaderType conflictType = sectionHeaderTypeMap.get(type.value);
        if (conflictType != null) {
            throw new DuplicateNameException("ElfSectionHeaderType conflict during initialization (" + type.name + " / " + conflictType.name + "), value=0x" + Integer.toHexString(type.value));
        }
        for (ElfSectionHeaderType existingType : sectionHeaderTypeMap.values()) {
            if (!type.name.equalsIgnoreCase(existingType.name)) continue;
            throw new DuplicateNameException("ElfSectionHeaderType conflict during initialization, name=" + type.name);
        }
        sectionHeaderTypeMap.put(type.value, type);
    }

    public ElfSectionHeaderType(int value, String name, String description) {
        this.value = value;
        this.name = name;
        this.description = description;
    }

    public static void addDefaultTypes(Map<Integer, ElfSectionHeaderType> programHeaderTypeMap) {
        programHeaderTypeMap.putAll(defaultElfSectionHeaderTypeMap);
    }

    public static EnumDataType getEnumDataType(boolean is32bit, String typeSuffix, Map<Integer, ElfSectionHeaderType> dynamicTypeMap) {
        Object name;
        int size = is32bit ? 4 : 8;
        Object object = name = is32bit ? "Elf32_PHType" : "Elf64_PHType";
        if (typeSuffix != null) {
            name = (String)name + typeSuffix;
        }
        EnumDataType phTypeEnum = new EnumDataType(new CategoryPath("/ELF"), (String)name, size);
        for (ElfSectionHeaderType type : dynamicTypeMap.values()) {
            phTypeEnum.add(type.name, (long)type.value);
        }
        return phTypeEnum;
    }

    public String toString() {
        return this.name + "(0x" + StringUtilities.pad((String)Integer.toHexString(this.value), (char)'0', (int)8) + ")";
    }
}

