/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.RelocationResult;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractElfRelocationHandler<T extends ElfRelocationType, C extends ElfRelocationContext<?>>
extends ElfRelocationHandler {
    private Map<Integer, T> relocationTypesMap;

    protected AbstractElfRelocationHandler(Class<T> relocationEnumClass) {
        this.initRelocationTypeMap(relocationEnumClass);
    }

    private void initRelocationTypeMap(Class<T> relocationEnumClass) {
        if (!relocationEnumClass.isEnum() || !ElfRelocationType.class.isAssignableFrom(relocationEnumClass)) {
            throw new IllegalArgumentException("Invalid class specified - expected enum which implements ElfRelocationType: " + relocationEnumClass.getName());
        }
        this.relocationTypesMap = new HashMap<Integer, T>();
        for (ElfRelocationType t : (ElfRelocationType[])relocationEnumClass.getEnumConstants()) {
            this.relocationTypesMap.put(t.typeId(), t);
        }
    }

    public T getRelocationType(int typeId) {
        if (this.relocationTypesMap == null) {
            return null;
        }
        return (T)((ElfRelocationType)this.relocationTypesMap.get(typeId));
    }

    @Override
    protected final RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        int symbolIndex = relocation.getSymbolIndex();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        Address symbolAddr = elfRelocationContext.getSymbolAddress(sym);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
        int typeId = relocation.getType();
        if (typeId == 0) {
            return RelocationResult.SKIPPED;
        }
        T type = this.getRelocationType(typeId);
        if (type == null) {
            this.markAsUndefined(program, relocationAddress, typeId, symbolName, symbolIndex, elfRelocationContext.getLog());
            return RelocationResult.UNSUPPORTED;
        }
        return this.relocate(elfRelocationContext, relocation, type, relocationAddress, sym, symbolAddr, symbolValue, symbolName);
    }

    protected abstract RelocationResult relocate(C var1, ElfRelocation var2, T var3, Address var4, ElfSymbol var5, Address var6, long var7, String var9) throws MemoryAccessException;

    protected boolean handleUnresolvedSymbol(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, Address relocationAddress) {
        int symbolIndex = relocation.getSymbolIndex();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        Address symbolAddr = elfRelocationContext.getSymbolAddress(sym);
        if (symbolIndex != 0 && symbolAddr == null) {
            int typeId = relocation.getType();
            T type = this.getRelocationType(typeId);
            String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
            Program program = elfRelocationContext.getProgram();
            this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
            this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to resolve relocation symbol", elfRelocationContext.getLog());
            return true;
        }
        return false;
    }

    private String getRelocationTypeDetail(T relocationType) {
        int typeId = relocationType.typeId();
        return relocationType.name() + " (" + typeId + ", 0x" + Integer.toHexString(typeId) + ")";
    }

    protected void markAsUnsupportedCopy(Program program, Address relocationAddress, T relocationType, String symbolName, int symbolIndex, long symbolSize, MessageLog log) {
        this.markAsWarning(program, relocationAddress, relocationType, symbolName, symbolIndex, "Runtime copy not supported (" + symbolSize + "-bytes)", log);
    }

    protected void markAsUndefined(Program program, Address relocationAddress, int typeId, String symbolName, int symbolIndex, MessageLog log) {
        AbstractElfRelocationHandler.markupErrorOrWarning(program, "Undefined ELF Relocation", null, relocationAddress, AbstractElfRelocationHandler.getDefaultRelocationTypeDetail(typeId), symbolIndex, symbolName, "Error", log);
    }

    protected void markAsUnhandled(Program program, Address relocationAddress, T relocationType, int symbolIndex, String symbolName, MessageLog log) {
        AbstractElfRelocationHandler.markupErrorOrWarning(program, "Unhandled ELF Relocation", null, relocationAddress, this.getRelocationTypeDetail(relocationType), symbolIndex, symbolName, "Error", log);
    }

    protected void markAsWarning(Program program, Address relocationAddress, T relocationType, String symbolName, int symbolIndex, String msg, MessageLog log) {
        AbstractElfRelocationHandler.markupErrorOrWarning(program, "ELF Relocation Failure", msg, relocationAddress, this.getRelocationTypeDetail(relocationType), symbolIndex, symbolName, "Warning", log);
    }

    protected void markAsError(Program program, Address relocationAddress, T relocationType, String symbolName, int symbolIndex, String msg, MessageLog log) {
        AbstractElfRelocationHandler.markupErrorOrWarning(program, "Elf Relocation Failure", msg, relocationAddress, this.getRelocationTypeDetail(relocationType), symbolIndex, symbolName, "Error", log);
    }
}

