/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import generic.jar.ResourceFile;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.rtti.GoSymbolName;
import ghidra.app.util.bin.format.golang.rtti.JsonPatch;
import ghidra.app.util.bin.format.golang.rtti.JsonPatchApplier;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.Application;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GoApiSnapshot {
    private static final Set<String> IS_GOOS_UNIX = Set.of("aix", "android", "darwin", "dragonfly", "freebsd", "hurd", "illumos", "ios", "linux", "netbsd", "openbsd", "solaris");
    public static final GoApiSnapshot EMPTY = new GoApiSnapshot(GoVer.INVALID, Map.of());
    private final Map<String, GoArch> arches;
    private final GoVer ver;

    public static GoApiSnapshot get(GoVer goVer, String goArch, String goOS, TaskMonitor monitor) throws IOException, CancelledException {
        block12: {
            try (ByteProvider bp = GoApiSnapshot.getApiSnapshotJsonFile(goVer, monitor);){
                GoApiSnapshot goApiSnapshot;
                block13: {
                    if (bp == null) break block12;
                    InputStream is = bp.getInputStream(0L);
                    try {
                        List<String> archSearchOrder = List.of(goOS + "-" + goArch, goOS, IS_GOOS_UNIX.contains(goOS) ? "unix" : "", goArch, "all");
                        goApiSnapshot = GoApiSnapshot.read(is, archSearchOrder, goVer);
                        if (is == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return goApiSnapshot;
            }
        }
        return EMPTY;
    }

    public static ByteProvider getApiSnapshotJsonFile(GoVer goVer, TaskMonitor monitor) throws IOException, CancelledException {
        FileSystemService fsService = FileSystemService.getInstance();
        GoVer baseVer = goVer.withPatch(0);
        File jsonFile = GoApiSnapshot.getApiSnapshotFile(baseVer, "", "");
        if (jsonFile == null) {
            return null;
        }
        ByteProvider bp = null;
        if (goVer.getPatch() == 0) {
            bp = fsService.getByteProvider(fsService.getLocalFSRL(jsonFile), false, monitor);
        } else {
            File patchDiffFile = GoApiSnapshot.getApiSnapshotFile(goVer, "patchverdiffs/", ".diff");
            if (patchDiffFile != null) {
                FSRL fsrl = fsService.getFullyQualifiedFSRL(fsService.getLocalFSRL(jsonFile), monitor);
                bp = fsService.getDerivedByteProviderPush(fsrl, null, "go%s.json".formatted(goVer), -1L, os -> {
                    JsonPatch jsonPatch = JsonPatch.read(patchDiffFile);
                    JsonPatchApplier jpa = new JsonPatchApplier(jsonFile);
                    monitor.initialize((long)jsonPatch.getSectionCount(), "Patching golang api snapshot %s -> %s".formatted(baseVer, goVer));
                    jpa.apply(jsonPatch, monitor);
                    OutputStreamWriter osw = new OutputStreamWriter(os, StandardCharsets.UTF_8);
                    new Gson().toJson(jpa.getJson(), (Appendable)osw);
                    osw.flush();
                }, monitor);
            }
        }
        return bp;
    }

    static File getApiSnapshotFile(GoVer goVer, String subdir, String suffix) {
        try {
            ResourceFile rfile = Application.getModuleDataFile((String)"typeinfo/golang/%sgo%s.json%s".formatted(subdir, goVer.toString(), suffix));
            return rfile.getFile(true);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File getApiFile(File baseDir, GoVer ver) {
        String filename = "go%d.%d.%d.json".formatted(ver.getMajor(), ver.getMinor(), ver.getPatch());
        File f = new File(baseDir, filename);
        if (!f.isFile() && ver.getPatch() == 0) {
            filename = "go%d.%d.json".formatted(ver.getMajor(), ver.getMinor());
            f = new File(baseDir, filename);
        }
        return f.isFile() ? f : null;
    }

    private static GoApiSnapshot read(InputStream is, List<String> archNames, GoVer ver) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter(GoTypeDef.class, (Object)new GoTypeDefDeserializer()).create();
        HashMap<String, GoArch> arches = new HashMap<String, GoArch>();
        HashSet<String> archNamesToKeep = new HashSet<String>(archNames);
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(is));){
            reader.beginObject();
            while (reader.peek() == JsonToken.NAME) {
                String archName = reader.nextName();
                if (!archNamesToKeep.contains(archName)) {
                    reader.skipValue();
                    continue;
                }
                GoArch arch = (GoArch)gson.fromJson(reader, GoArch.class);
                arches.put(archName, arch);
            }
            reader.endObject();
        }
        LinkedHashMap<String, GoArch> results = new LinkedHashMap<String, GoArch>();
        for (String archName : archNames) {
            GoArch arch;
            if (archName == null || archName.isEmpty() || (arch = (GoArch)arches.get(archName)) == null) continue;
            results.put(archName, arch);
        }
        return new GoApiSnapshot(ver, results);
    }

    public GoApiSnapshot(GoVer ver, Map<String, GoArch> arches) {
        this.ver = ver;
        this.arches = arches;
    }

    public GoVer getVer() {
        return this.ver;
    }

    public GoFuncDef getFuncdef(String funcName) {
        for (GoArch arch : this.arches.values()) {
            GoFuncDef funcDef = arch.Funcs.get(funcName);
            if (funcDef == null) continue;
            return funcDef;
        }
        return null;
    }

    public GoTypeDef getTypeDef(String typeName) {
        for (GoArch arch : this.arches.values()) {
            GoTypeDef typeDef = arch.Types.get(typeName);
            if (typeDef == null) continue;
            return typeDef;
        }
        return null;
    }

    public static class GoTypeDef {
        public String toString() {
            return "GoTypeDef []";
        }
    }

    static class GoTypeDefDeserializer
    implements JsonDeserializer<GoTypeDef> {
        GoTypeDefDeserializer() {
        }

        public GoTypeDef deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String Kind2;
            JsonObject obj = json.getAsJsonObject();
            switch (Kind2 = obj.get("Kind").getAsString()) {
                case "struct": {
                    return (GoTypeDef)context.deserialize((JsonElement)obj, GoStructDef.class);
                }
                case "iface": {
                    return (GoTypeDef)context.deserialize((JsonElement)obj, GoInterfaceDef.class);
                }
                case "basic": {
                    return (GoTypeDef)context.deserialize((JsonElement)obj, GoBasicDef.class);
                }
                case "alias": {
                    return (GoTypeDef)context.deserialize((JsonElement)obj, GoAliasDef.class);
                }
                case "funcdef": {
                    return (GoTypeDef)context.deserialize((JsonElement)obj, GoFuncTypeDef.class);
                }
            }
            return null;
        }
    }

    static class GoArch {
        Map<String, GoFuncDef> Funcs;
        Map<String, GoTypeDef> Types;

        GoArch() {
        }
    }

    public static class GoFuncDef {
        List<GoNameTypePair> Params;
        List<GoNameTypePair> Results;
        List<String> TypeParams;
        int Flags;

        EnumSet<FuncFlags> getFuncFlags() {
            return FuncFlags.parse(this.Flags);
        }

        public String toString() {
            return "GoFuncDef [Params=" + String.valueOf(this.Params) + ", Results=" + String.valueOf(this.Results) + ", TypeParams=" + String.valueOf(this.TypeParams) + ", Flags=" + this.Flags + "]";
        }

        public String getDefinitionString(GoSymbolName symbolName) {
            Object resultsStr = this.Results.size() == 0 ? "" : (this.Results.size() == 1 && this.Results.get((int)0).Name.isEmpty() ? " " + this.Results.get((int)0).DataType : " (%s)".formatted(GoNameTypePair.listToString(this.Results)));
            List<GoNameTypePair> tmpParams = this.Params;
            if (symbolName.hasReceiver() && this.Params.size() > 0) {
                tmpParams = this.Params.subList(1, this.Params.size());
            }
            return "func %s(%s)%s".formatted(symbolName.asString(), GoNameTypePair.listToString(tmpParams), resultsStr);
        }
    }

    public static class GoFuncTypeDef
    extends GoTypeDef {
        List<GoNameTypePair> Params;
        List<GoNameTypePair> Results;
        List<String> TypeParams;
        int Flags;

        @Override
        public String toString() {
            return "GoFuncTypeDef [Params=" + String.valueOf(this.Params) + ", Results=" + String.valueOf(this.Results) + ", TypeParams=" + String.valueOf(this.TypeParams) + ", Flags=" + this.Flags + "]";
        }
    }

    public static class GoBasicDef
    extends GoTypeDef {
        String DataType;
        Map<String, String> EnumValues;

        @Override
        public String toString() {
            return "GoBasicDef [DataType=" + this.DataType + ", EnumValues=" + String.valueOf(this.EnumValues) + "]";
        }
    }

    public static class GoAliasDef
    extends GoTypeDef {
        String Target;

        @Override
        public String toString() {
            return "GoAliasDef [Target=" + this.Target + "]";
        }
    }

    public static class GoInterfaceDef
    extends GoTypeDef {
        @Override
        public String toString() {
            return "GoInterfaceDef []";
        }
    }

    public static class GoStructDef
    extends GoTypeDef {
        List<GoNameTypePair> Fields;
        List<String> TypeParams;

        @Override
        public String toString() {
            return "GoStructDef [Fields=" + String.valueOf(this.Fields) + ", TypeParams=" + String.valueOf(this.TypeParams) + "]";
        }
    }

    public static enum FuncFlags {
        VarArg(1),
        Generic(2),
        Method(4),
        NoReturn(8);

        private int flagVal;
        private static final FuncFlags[] vals;

        private FuncFlags(int i) {
            this.flagVal = i;
        }

        public static EnumSet<FuncFlags> parse(int i) {
            EnumSet<FuncFlags> result = EnumSet.noneOf(FuncFlags.class);
            for (FuncFlags ff : vals) {
                if ((i & ff.flagVal) == 0) continue;
                result.add(ff);
            }
            return result;
        }

        static {
            vals = FuncFlags.values();
        }
    }

    public static class GoNameTypePair {
        String Name;
        String DataType;

        public String toString() {
            return "GoNameTypePair [Name=" + this.Name + ", DataType=" + this.DataType + "]";
        }

        public String getPairString() {
            Object s = Objects.requireNonNullElse(this.Name, "");
            if (this.DataType != null && !this.DataType.isEmpty()) {
                if (!((String)s).isEmpty()) {
                    s = (String)s + " ";
                }
                s = (String)s + this.DataType;
            }
            return s;
        }

        public static String listToString(List<GoNameTypePair> list) {
            return list.stream().map(item -> item.getPairString()).collect(Collectors.joining(", "));
        }
    }
}

