/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import ghidra.app.util.bin.format.golang.rtti.JsonPatch;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class JsonPatchApplier {
    private static final String ROOT_ELEM_NAME = "rootElement";
    private JsonObject rootContainer = new JsonObject();

    public JsonPatchApplier(JsonElement json) {
        this.rootContainer.add(ROOT_ELEM_NAME, json);
    }

    public JsonPatchApplier(File baseFile) throws IOException {
        try (FileReader reader = new FileReader(baseFile, StandardCharsets.UTF_8);){
            this.rootContainer.add(ROOT_ELEM_NAME, JsonParser.parseReader((Reader)reader));
        }
    }

    public JsonElement getJson() {
        return this.rootContainer.get(ROOT_ELEM_NAME);
    }

    public void apply(String patchString, TaskMonitor monitor) throws IOException, CancelledException {
        this.apply(JsonPatch.read(patchString), monitor);
    }

    public void apply(JsonPatch patch, TaskMonitor monitor) throws IOException, CancelledException {
        for (JsonPatch.PatchSection section : patch.getSections()) {
            monitor.increment();
            this.applySection(section);
        }
    }

    public void writeJson(File destFile) throws IOException {
        try (FileWriter fw = new FileWriter(destFile);){
            new Gson().toJson(this.getJson(), (Appendable)fw);
        }
    }

    private void applySection(JsonPatch.PatchSection section) throws IOException {
        JsonPrimitive prim;
        JsonPrimitive prim2;
        JsonPrimitive targetId;
        JsonArray path = section.path();
        List<JsonPatch.PatchLine> lines = section.lines();
        JsonElement parent = this.findParent(path);
        Object object = targetId = path.size() > 0 ? path.get(path.size() - 1) : new JsonPrimitive(ROOT_ELEM_NAME);
        if (targetId instanceof JsonPrimitive && (prim2 = targetId).isString() && parent instanceof JsonObject) {
            JsonObject parentObj = (JsonObject)parent;
            String targetName = prim2.getAsString();
            int i = 0;
            if (lines.get(i).operation() == JsonPatch.PatchOp.REMOVE) {
                parentObj.remove(targetName);
                ++i;
            }
            if (i < lines.size() && lines.get(i).operation() == JsonPatch.PatchOp.ADD) {
                parentObj.add(targetName, lines.get(i).value());
            }
        } else if (targetId instanceof JsonPrimitive && (prim = targetId).isNumber() && parent instanceof JsonArray) {
            int i;
            JsonArray parentArray = (JsonArray)parent;
            int targetIndex = prim.getAsInt();
            for (i = 0; i < lines.size() && lines.get(i).operation() == JsonPatch.PatchOp.REMOVE; ++i) {
                parentArray.remove(targetIndex);
            }
            ArrayList<JsonElement> arrayElems = new ArrayList<JsonElement>(parentArray.size());
            parentArray.forEach(arrayElems::add);
            while (i < lines.size() && lines.get(i).operation() == JsonPatch.PatchOp.ADD) {
                arrayElems.add(targetIndex, lines.get(i).value());
                ++targetIndex;
                ++i;
            }
            if (arrayElems.size() != parentArray.size()) {
                while (parentArray.size() > 0) {
                    parentArray.remove(parentArray.size() - 1);
                }
                arrayElems.forEach(arg_0 -> ((JsonArray)parentArray).add(arg_0));
            }
        } else {
            throw new IOException("unsupported section");
        }
    }

    private JsonElement findParent(JsonArray path) throws IOException {
        if (path.size() == 0) {
            return this.rootContainer;
        }
        JsonElement current = this.rootContainer.get(ROOT_ELEM_NAME);
        if (current == null) {
            throw new IOException("missing rootContainer element");
        }
        try {
            for (int i = 0; i < path.size() - 1; ++i) {
                JsonElement pathElem = path.get(i);
                JsonElement nextElem = null;
                if (pathElem instanceof JsonPrimitive) {
                    JsonPrimitive prim = (JsonPrimitive)pathElem;
                    if (prim.isString()) {
                        nextElem = current.getAsJsonObject().get(prim.getAsString());
                    } else if (prim.isNumber()) {
                        int index = prim.getAsNumber().intValue();
                        nextElem = current.getAsJsonArray().get(index);
                    }
                }
                if (nextElem == null) {
                    throw new IOException("Could not find next element in path: " + String.valueOf(path) + ", " + i);
                }
                current = nextElem;
            }
            return current;
        }
        catch (IllegalStateException e) {
            throw new IOException("invalid json diff data");
        }
    }
}

