/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho;

import ghidra.program.model.lang.Processor;

public final class CpuTypes {
    public static final int CPU_ARCH_MASK = -16777216;
    public static final int CPU_ARCH_ABI64 = 0x1000000;
    public static final int CPU_ARCH_ABI64_32 = 0x2000000;
    public static final int CPU_TYPE_ANY = -1;
    public static final int CPU_TYPE_VAX = 1;
    public static final int CPU_TYPE_MC680x0 = 6;
    public static final int CPU_TYPE_X86 = 7;
    public static final int CPU_TYPE_I386 = 7;
    public static final int CPU_TYPE_MC98000 = 10;
    public static final int CPU_TYPE_HPPA = 11;
    public static final int CPU_TYPE_ARM = 12;
    public static final int CPU_TYPE_MC88000 = 13;
    public static final int CPU_TYPE_SPARC = 14;
    public static final int CPU_TYPE_I860 = 15;
    public static final int CPU_TYPE_POWERPC = 18;
    public static final int CPU_TYPE_POWERPC64 = 0x1000012;
    public static final int CPU_TYPE_X86_64 = 0x1000007;
    public static final int CPU_TYPE_ARM_64 = 0x100000C;
    public static final int CPU_TYPE_ARM64_32 = 0x200000C;

    public static final Processor getProcessor(int cpuType, int cpuSubtype) {
        switch (cpuType) {
            case 7: {
                return Processor.findOrPossiblyCreateProcessor((String)"x86");
            }
            case 0x1000007: {
                return Processor.findOrPossiblyCreateProcessor((String)"x86");
            }
            case 18: {
                return Processor.findOrPossiblyCreateProcessor((String)"PowerPC");
            }
            case 0x1000012: {
                return Processor.findOrPossiblyCreateProcessor((String)"PowerPC");
            }
            case 15: {
                return Processor.findOrPossiblyCreateProcessor((String)"i860");
            }
            case 14: {
                return Processor.findOrPossiblyCreateProcessor((String)"Sparc");
            }
            case 12: {
                return Processor.findOrPossiblyCreateProcessor((String)"ARM");
            }
            case 0x100000C: {
                return Processor.findOrPossiblyCreateProcessor((String)"AARCH64");
            }
            case 0x200000C: {
                return Processor.findOrPossiblyCreateProcessor((String)"AARCH64");
            }
        }
        throw new RuntimeException("Unrecognized CPU type: 0x" + Integer.toHexString(cpuType));
    }

    public static final int getProcessorBitSize(int cpuType) {
        return switch (cpuType) {
            case 7, 12, 14, 15, 18, 0x200000C -> 32;
            case 0x1000007, 0x100000C, 0x1000012 -> 64;
            default -> throw new RuntimeException("Unrecognized CPU type: 0x" + Integer.toHexString(cpuType));
        };
    }

    public static String getMagicString(int cpuType, int cpuSubtype) {
        return switch (cpuType) {
            case 12 -> cpuType + "." + cpuSubtype;
            default -> "" + cpuType;
        };
    }
}

