/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordTypes;
import ghidra.app.util.bin.format.omf.omf51.Omf51Segment;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Omf51SegmentDefs
extends OmfRecord {
    private boolean largeSegmentId;
    private List<Omf51Segment> segments = new ArrayList<Omf51Segment>();

    public Omf51SegmentDefs(BinaryReader reader, boolean largeSegmentId) throws IOException {
        super(reader);
        this.largeSegmentId = largeSegmentId;
    }

    @Override
    public void parseData() throws IOException, OmfException {
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            this.segments.add(new Omf51Segment(this.dataReader, this.largeSegmentId));
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(Omf51RecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        for (Omf51Segment segment : this.segments) {
            struct.add(this.largeSegmentId ? WORD : BYTE, "id", null);
            struct.add(BYTE, "info", null);
            struct.add(BYTE, "rel type", null);
            struct.add(BYTE, "unused", null);
            struct.add(WORD, "base", null);
            struct.add(WORD, "size", null);
            struct.add(segment.name().toDataType(), segment.name().getDataTypeSize(), "name", null);
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }

    public List<Omf51Segment> getSegments() {
        return this.segments;
    }
}

