/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class CliSigConstant
extends CliAbstractSig {
    private CliAbstractSig.CliElementType type;
    private Object value;

    public CliSigConstant(CliBlob blob, CliAbstractSig.CliElementType elementType) throws IOException {
        super(blob);
        this.type = elementType;
        BinaryReader reader = blob.getContentsReader();
        switch (this.type) {
            case ELEMENT_TYPE_BOOLEAN: 
            case ELEMENT_TYPE_CHAR: {
                this.value = reader.readNextByte();
                break;
            }
            case ELEMENT_TYPE_U2: {
                this.value = reader.readNextUnsignedShort();
                break;
            }
            case ELEMENT_TYPE_I2: {
                this.value = reader.readNextShort();
                break;
            }
            case ELEMENT_TYPE_U4: {
                this.value = reader.readNextUnsignedInt();
                break;
            }
            case ELEMENT_TYPE_I4: {
                this.value = reader.readNextInt();
                break;
            }
            case ELEMENT_TYPE_R4: {
                this.value = Float.valueOf(ByteBuffer.wrap(reader.readNextByteArray(4)).order(ByteOrder.LITTLE_ENDIAN).getFloat());
                break;
            }
            case ELEMENT_TYPE_U8: {
                this.value = ByteBuffer.wrap(reader.readNextByteArray(8)).getLong();
                break;
            }
            case ELEMENT_TYPE_I8: {
                this.value = reader.readNextLong();
                break;
            }
            case ELEMENT_TYPE_R8: {
                this.value = ByteBuffer.wrap(reader.readNextByteArray(8)).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                break;
            }
            case ELEMENT_TYPE_STRING: {
                byte[] stringConstantBytes = reader.readNextByteArray(this.contentsSize);
                this.value = new String(stringConstantBytes, StandardCharsets.UTF_16LE);
                break;
            }
            default: {
                Msg.warn((Object)this, (Object)("An unrecognized data type was detected in a Constant blob: type " + elementType.name() + " @ " + blob.getName()));
                return;
            }
        }
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        switch (this.type) {
            case ELEMENT_TYPE_BOOLEAN: 
            case ELEMENT_TYPE_CHAR: {
                struct.add(BYTE, this.type.name(), "");
                break;
            }
            case ELEMENT_TYPE_U2: {
                struct.add(WORD, this.type.name(), "");
                break;
            }
            case ELEMENT_TYPE_I2: {
                if ((Integer)this.value < 0) {
                    struct.add(WORD, this.type.name(), this.getRepresentation());
                    break;
                }
                struct.add(WORD, this.type.name(), "");
                break;
            }
            case ELEMENT_TYPE_U4: {
                struct.add(DWORD, this.type.name(), "");
                break;
            }
            case ELEMENT_TYPE_I4: {
                if ((Integer)this.value < 0) {
                    struct.add(DWORD, this.type.name(), this.getRepresentation());
                    break;
                }
                struct.add(DWORD, this.type.name(), "");
                break;
            }
            case ELEMENT_TYPE_R4: {
                struct.add(DWORD, this.type.name(), this.getRepresentation());
                break;
            }
            case ELEMENT_TYPE_U8: {
                struct.add(QWORD, this.type.name(), "");
                break;
            }
            case ELEMENT_TYPE_I8: {
                if ((Long)this.value < 0L) {
                    struct.add(QWORD, this.type.name(), this.getRepresentation());
                    break;
                }
                struct.add(QWORD, this.type.name(), "");
                break;
            }
            case ELEMENT_TYPE_R8: {
                struct.add(QWORD, this.type.name(), this.getRepresentation());
                break;
            }
            case ELEMENT_TYPE_STRING: {
                struct.add(UTF16, this.contentsSize, this.type.name(), "");
            }
        }
        return struct;
    }

    @Override
    public String getContentsName() {
        return "ConstantSig";
    }

    @Override
    public String getContentsComment() {
        return "Data stored in a constant";
    }

    @Override
    public String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        return this.value.toString();
    }
}

