/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliSigField
extends CliAbstractSig {
    private CliAbstractSig.CliParam type;
    private long dataOffset;
    private static final byte CLISIGFIELD_PROLOG = 6;

    public CliSigField(CliBlob blob) throws IOException {
        super(blob);
        BinaryReader reader = this.getContentsReader();
        this.dataOffset = reader.getPointerIndex();
        byte prolog = reader.readNextByte();
        if (prolog != 6) {
            Msg.warn((Object)this, (Object)("CliSigField had unexpected prolog (0x" + Integer.toHexString(prolog) + ")."));
            return;
        }
        try {
            this.type = new CliAbstractSig.CliParam(this, reader);
        }
        catch (InvalidInputException e) {
            this.type = null;
        }
    }

    public static boolean isFieldSig(CliBlob blob) throws IOException {
        return blob.getContentsReader().readNextByte() == 6;
    }

    public CliAbstractSig.CliParam getType() {
        return this.type;
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add(BYTE, "FIELD", "Magic (0x06)");
        struct.add(this.type.getDefinitionDataType(), this.type.getType().baseTypeCode.toString(), null);
        return struct;
    }

    @Override
    public String getContentsName() {
        return "FieldSig";
    }

    @Override
    public String getContentsComment() {
        return "Type information for Field";
    }

    @Override
    public String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        return this.getRepresentationOf(this.type, stream, isShort);
    }
}

