/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class TargetProtocolConformanceDescriptor
extends SwiftTypeMetadataStructure {
    private int protocolDescriptor;
    private int nominalTypeDescriptor;
    private int protocolWitnessTable;
    private int conformanceFlags;

    public TargetProtocolConformanceDescriptor(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.protocolDescriptor = reader.readNextInt();
        this.nominalTypeDescriptor = reader.readNextInt();
        this.protocolWitnessTable = reader.readNextInt();
        this.conformanceFlags = reader.readNextInt();
    }

    public int getProtocolDescriptor() {
        return this.protocolDescriptor;
    }

    public int getNominalTypeDescriptor() {
        return this.nominalTypeDescriptor;
    }

    public int getProtocolWitnessTable() {
        return this.protocolWitnessTable;
    }

    public int getConformanceFlags() {
        return this.conformanceFlags;
    }

    @Override
    public String getStructureName() {
        return TargetProtocolConformanceDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "protocol conformance descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getStructureName(), 0);
        struct.add(DWORD, "ProtocolDescriptor", "The protocol being conformed to");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "NominalTypeDescriptor", "Some description of the type that conforms to the protocol");
        struct.add(DWORD, "ProtocolWitnessTable", "The witness table pattern, which may also serve as the witness table");
        struct.add(DWORD, "ConformanceFlags", "Various flags, including the kind of conformance");
        struct.setCategoryPath(new CategoryPath("/SwiftTypeMetadata"));
        return struct;
    }
}

