/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.unixaout;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.unixaout.UnixAoutStringTable;
import ghidra.app.util.bin.format.unixaout.UnixAoutSymbol;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class UnixAoutSymbolTable
implements Iterable<UnixAoutSymbol>,
StructConverter {
    private static final int ENTRY_SIZE = 12;
    private final long fileSize;
    private List<UnixAoutSymbol> symbols;

    public UnixAoutSymbolTable(BinaryReader reader, long fileOffset, long fileSize, UnixAoutStringTable strtab, MessageLog log) throws IOException {
        this.fileSize = fileSize;
        this.symbols = new ArrayList<UnixAoutSymbol>();
        reader.setPointerIndex(fileOffset);
        int idx = 0;
        while (reader.getPointerIndex() < fileOffset + fileSize) {
            long strOffset = reader.readNextUnsignedInt();
            byte typeByte = reader.readNextByte();
            byte otherByte = reader.readNextByte();
            short desc = reader.readNextShort();
            long value = reader.readNextUnsignedInt();
            UnixAoutSymbol symbol = new UnixAoutSymbol(strOffset, typeByte, otherByte, desc, value);
            if (symbol.type == UnixAoutSymbol.SymbolType.UNKNOWN) {
                log.appendMsg(".symtab", String.format("Unknown symbol type 0x%02x at symbol index %d", typeByte, idx));
            }
            this.symbols.add(symbol);
            ++idx;
        }
        for (UnixAoutSymbol symbol : this) {
            symbol.name = strtab.readString(symbol.nameStringOffset);
        }
    }

    @Override
    public Iterator<UnixAoutSymbol> iterator() {
        return this.symbols.iterator();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String dtName = "nlist";
        StructureDataType struct = new StructureDataType(new CategoryPath("/AOUT"), dtName, 0);
        struct.add(DWORD, "n_strx", null);
        struct.add(BYTE, "n_type", null);
        struct.add(BYTE, "n_other", null);
        struct.add(WORD, "n_desc", null);
        struct.add(DWORD, "n_value", null);
        return new ArrayDataType((DataType)struct, (int)(this.fileSize / 12L), 12);
    }

    public UnixAoutSymbol get(int symbolNum) {
        return this.symbols.get(symbolNum);
    }

    public long size() {
        return this.symbols.size();
    }

    public void markup(Program program, MemoryBlock block) throws CodeUnitInsertionException, DuplicateNameException, IOException {
        Listing listing = program.getListing();
        Data array = listing.createData(block.getStart(), this.toDataType());
        int idx = 0;
        for (UnixAoutSymbol symbol : this) {
            Data structData;
            if (!StringUtils.isBlank((CharSequence)symbol.name) && (structData = array.getComponent(idx)) != null) {
                structData.setComment(CommentType.EOL, symbol.name);
            }
            ++idx;
        }
    }
}

