/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.xcoff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.xcoff.XCoffFileHeader;
import ghidra.app.util.bin.format.xcoff.XCoffFileHeaderMagic;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class XCoffOptionalHeader
implements StructConverter {
    private static final char NL = '\n';
    public static final int AOUTHDRSZ = 72;
    private short o_magic;
    private short o_vstamp;
    private long o_tsize;
    private long o_dsize;
    private long o_bsize;
    private long o_entry;
    private long o_text_start;
    private long o_data_start;
    private long o_toc;
    private short o_snentry;
    private short o_sntext;
    private short o_sndata;
    private short o_sntoc;
    private short o_snloader;
    private short o_snbss;
    private short o_algntext;
    private short o_algndata;
    private byte[] o_modtype;
    private byte o_cpuflag;
    private byte o_cputype;
    private long o_maxstack;
    private long o_maxdata;
    private long o_debugger;
    private byte o_flags;
    private short o_sntdata;
    private short o_sntbss;

    XCoffOptionalHeader(BinaryReader reader, XCoffFileHeader header) throws IOException {
        this.o_magic = reader.readNextShort();
        this.o_vstamp = reader.readNextShort();
        if (XCoffFileHeaderMagic.is32bit(header)) {
            this.o_tsize = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_dsize = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_bsize = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_entry = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_text_start = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_data_start = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_toc = (long)reader.readNextInt() & 0xFFFFFFFFL;
        } else if (XCoffFileHeaderMagic.is64bit(header)) {
            this.o_tsize = reader.readNextLong();
            this.o_dsize = reader.readNextLong();
            this.o_bsize = reader.readNextLong();
            this.o_entry = reader.readNextLong();
            this.o_text_start = reader.readNextLong();
            this.o_data_start = reader.readNextLong();
            this.o_toc = reader.readNextLong();
        }
        this.o_snentry = reader.readNextShort();
        this.o_sntext = reader.readNextShort();
        this.o_sndata = reader.readNextShort();
        this.o_sntoc = reader.readNextShort();
        this.o_snloader = reader.readNextShort();
        this.o_snbss = reader.readNextShort();
        this.o_algntext = reader.readNextShort();
        this.o_algndata = reader.readNextShort();
        this.o_modtype = reader.readNextByteArray(2);
        this.o_cpuflag = reader.readNextByte();
        this.o_cputype = reader.readNextByte();
        if (XCoffFileHeaderMagic.is32bit(header)) {
            this.o_maxstack = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_maxdata = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_debugger = (long)reader.readNextInt() & 0xFFFFFFFFL;
        } else if (XCoffFileHeaderMagic.is64bit(header)) {
            this.o_maxstack = reader.readNextLong();
            this.o_maxdata = reader.readNextLong();
            this.o_debugger = reader.readNextLong();
        }
        this.o_flags = reader.readNextByte();
        this.o_sntdata = reader.readNextShort();
        this.o_sntbss = reader.readNextShort();
    }

    public String toString() {
        String buffer = "OPTIONAL HEADER VALUES\nmagic      = " + this.o_magic + "\nvstamp     = " + this.o_vstamp + "\ntsize      = " + this.o_tsize + "\ndsize      = " + this.o_dsize + "\nbsize      = " + this.o_bsize + "\nentry      = " + this.o_entry + "\ntext_start = " + this.o_text_start + "\ndata_start = " + this.o_data_start + "\no_toc      = " + this.o_toc + "\no_snentry  = " + this.o_snentry + "\no_sntext   = " + this.getSectionNumberForText() + "\no_sndata   = " + this.o_sndata + "\no_sntoc    = " + this.o_sntoc + "\no_snloader = " + this.o_snloader + "\no_snbss    = " + this.o_snbss + "\no_algntext = " + this.o_algntext + "\no_algndata = " + this.o_algndata + "\no_modtype  = " + String.valueOf(this.o_modtype) + "\no_cpuflag  = " + this.o_cpuflag + "\no_cputype  = " + this.o_cputype + "\no_maxstack = " + this.o_maxstack + "\no_maxdata  = " + this.o_maxdata + "\no_flags    = " + this.o_flags + "\no_debugger = " + this.o_debugger + "\no_sntdata  = " + this.o_sntdata + "\no_sntbss   = " + this.o_sntbss + "\n";
        return buffer;
    }

    public short getMagic() {
        return this.o_magic;
    }

    public short getVersionStamp() {
        return this.o_vstamp;
    }

    public long getTextSize() {
        return this.o_tsize;
    }

    public long getInitializedDataSize() {
        return this.o_dsize;
    }

    public long getUninitializedDataSize() {
        return this.o_bsize;
    }

    public long getEntry() {
        return this.o_entry;
    }

    public long getTextStart() {
        return this.o_text_start;
    }

    public long getDataStart() {
        return this.o_data_start;
    }

    public long getTOC() {
        return this.o_toc;
    }

    public short getSectionNumberForEntry() {
        return this.o_snentry;
    }

    public short getSectionNumberForText() {
        return this.o_sntext;
    }

    public short getSectionNumberForData() {
        return this.o_sndata;
    }

    public short getSectionNumberForTOC() {
        return this.o_sntoc;
    }

    public short getSectionNumberForLoader() {
        return this.o_snloader;
    }

    public short getSectionNumberForBss() {
        return this.o_snbss;
    }

    public short getMaxAlignmentForText() {
        return this.o_algntext;
    }

    public short getMaxAlignmentForData() {
        return this.o_algndata;
    }

    public String getModuleType() {
        return new String(this.o_modtype);
    }

    public byte getCpuFlag() {
        return this.o_cpuflag;
    }

    public byte getCpuType() {
        return this.o_cputype;
    }

    public long getMaxStackSize() {
        return this.o_maxstack;
    }

    public long getMaxDataSize() {
        return this.o_maxdata;
    }

    public long getDebugger() {
        return this.o_debugger;
    }

    public byte getFlags() {
        return this.o_flags;
    }

    public short getSectionNumberForTData() {
        return this.o_sntdata;
    }

    public short getSectionNumberForTBss() {
        return this.o_sntbss;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(XCoffOptionalHeader.class);
    }
}

