/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.omf.OmfExternalSymbol;
import ghidra.app.util.bin.format.omf.omf.OmfFileHeader;
import ghidra.app.util.bin.format.omf.omf.OmfFixupRecord;
import ghidra.app.util.bin.format.omf.omf.OmfGroupRecord;
import ghidra.app.util.bin.format.omf.omf.OmfRecordFactory;
import ghidra.app.util.bin.format.omf.omf.OmfSegmentHeader;
import ghidra.app.util.bin.format.omf.omf.OmfSymbol;
import ghidra.app.util.bin.format.omf.omf.OmfSymbolRecord;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramWrapperLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.DataConverter;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OmfLoader
extends AbstractProgramWrapperLoader {
    public static final String OMF_NAME = "Relocatable Object Module Format (OMF)";
    public static final long MIN_BYTE_LENGTH = 11L;
    public static final long IMAGE_BASE = 8192L;
    public static final long MAX_UNINITIALIZED_FILL = 8192L;
    private List<OmfSymbol> externsyms = new ArrayList<OmfSymbol>();

    private String mapTranslator(String record) {
        String string;
        String string2 = record;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class, String.class, String.class, String.class}, (Object)string2, n)) {
                case 0: {
                    String s = string2;
                    if (!s.startsWith("Borland")) {
                        n = 1;
                        continue block8;
                    }
                    string = "boarlandcpp";
                    break block8;
                }
                case 1: {
                    String s = string2;
                    if (!s.startsWith("Delphi")) {
                        n = 2;
                        continue block8;
                    }
                    string = "borlanddelphi";
                    break block8;
                }
                case 2: {
                    String s = string2;
                    if (!s.startsWith("CodeGear")) {
                        n = 3;
                        continue block8;
                    }
                    string = "codegearcpp";
                    break block8;
                }
                case 3: {
                    String s = string2;
                    if (!s.equals("MS C")) {
                        n = 4;
                        continue block8;
                    }
                    string = "windows";
                    break block8;
                }
                case 4: {
                    String s = string2;
                    if (!s.startsWith("Watcom")) {
                        n = 5;
                        continue block8;
                    }
                    string = "watcom";
                    break block8;
                }
                case -1: {
                    string = null;
                    break block8;
                }
                default: {
                    string = null;
                    break block8;
                }
            }
            break;
        }
        return string;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 11L) {
            return loadSpecs;
        }
        OmfRecordFactory factory = new OmfRecordFactory(provider);
        if (OmfFileHeader.checkMagicNumber(factory.getReader())) {
            OmfFileHeader scan;
            factory.reset();
            try {
                scan = OmfFileHeader.scan(factory, TaskMonitor.DUMMY, true);
            }
            catch (OmfException e) {
                throw new IOException("Bad header format: " + e.getMessage());
            }
            List<QueryResult> results = QueryOpinionService.query(this.getName(), scan.getMachineName(), this.mapTranslator(scan.getTranslator()));
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, 8192L, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, 8192L, true));
            }
        }
        return loadSpecs;
    }

    @Override
    public String getName() {
        return OMF_NAME;
    }

    @Override
    protected void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        OmfFileHeader header = null;
        OmfRecordFactory factory = new OmfRecordFactory(provider);
        try {
            header = OmfFileHeader.parse(factory, monitor, log);
            header.resolveNames();
            header.sortSegmentDataBlocks();
            OmfFileHeader.doLinking(8192L, header.getSegments(), header.getGroups());
        }
        catch (OmfException e) {
            if (header == null) {
                throw new IOException("OMF File header was corrupted. " + e.getMessage());
            }
            log.appendMsg("File was corrupted - leaving partial program " + provider.getName());
        }
        FileBytes fileBytes = MemoryBlockUtils.createFileBytes(program, provider, monitor);
        try {
            this.processSegmentHeaders(factory.getReader(), header, program, monitor, log);
            this.processPublicSymbols(header, program, monitor, log);
            this.processExternalSymbols(header, program, monitor, log);
            this.processRelocations(header, program, monitor, log);
            this.markupRecords(program, fileBytes, header, log, monitor);
        }
        catch (AddressOverflowException e) {
            throw new IOException(e);
        }
    }

    private void markupRecords(Program program, FileBytes fileBytes, OmfFileHeader fileHeader, MessageLog log, TaskMonitor monitor) {
        monitor.setMessage("Marking up records...");
        int size = fileHeader.getRecords().stream().mapToInt(r -> r.getRecordLength() + 3).sum();
        try {
            Address recordSpaceAddr = AddressSpace.OTHER_SPACE.getAddress(0L);
            MemoryBlock headerBlock = MemoryBlockUtils.createInitializedBlock(program, true, "RECORDS", recordSpaceAddr, fileBytes, 0L, size, "", "", false, false, false, log);
            Address start = headerBlock.getStart();
            for (OmfRecord record : fileHeader.getRecords()) {
                DataUtilities.createData((Program)program, (Address)start.add(record.getRecordOffset()), (DataType)record.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                try {
                    DataUtilities.createData((Program)program, (Address)start.add(record.getRecordOffset()), (DataType)record.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                }
                catch (Exception e) {
                    log.appendMsg("Failed to markup record type 0x%x at offset 0x%x. %s.".formatted(record.getRecordType(), record.getRecordOffset(), e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            log.appendMsg("Failed to markup records: " + e.getMessage());
        }
    }

    private void relocationError(Program program, MessageLog log, Address addr, int type) {
        Object message;
        if (addr != null) {
            message = "Unable to process relocation at " + String.valueOf(addr) + " with type 0x" + Integer.toHexString(type);
            program.getBookmarkManager().setBookmark(addr, "Error", "Relocations", (String)message);
        } else {
            message = "Badly broken relocation";
        }
        log.appendMsg((String)message);
    }

    private void processRelocations(OmfFileHeader header, Program program, TaskMonitor monitor, MessageLog log) {
        Language language = program.getLanguage();
        OmfFixupRecord.Subrecord[] targetThreads = new OmfFixupRecord.Subrecord[4];
        List<OmfGroupRecord> groups = header.getGroups();
        DataConverter converter = DataConverter.getInstance((!header.isLittleEndian() ? 1 : 0) != 0);
        monitor.setMessage("Process relocations...");
        Memory memory = program.getMemory();
        block16: for (OmfFixupRecord fixup : header.getFixups()) {
            block17: for (OmfFixupRecord.Subrecord subrec : fixup.getSubrecords()) {
                if (monitor.isCancelled()) continue block16;
                if (subrec.isThreadSubrecord()) {
                    if (subrec.isFrameInSubThread()) continue;
                    targetThreads[subrec.getThreadNum()] = subrec;
                    continue;
                }
                long finalvalue = -1L;
                byte[] origbytes = null;
                int locationType = -1;
                Address locAddress = null;
                if (fixup.getDataBlock() == null) continue;
                try {
                    long targetAddr;
                    int index;
                    int method;
                    if (subrec.isTargetThread()) {
                        OmfFixupRecord.Subrecord rec = targetThreads[subrec.getFixThreadNum()];
                        method = subrec.getFixMethodWithSub(rec);
                        index = rec.getIndex();
                    } else {
                        method = subrec.getFixMethod();
                        index = subrec.getTargetDatum();
                    }
                    switch (method) {
                        case 0: 
                        case 4: {
                            targetAddr = header.resolveSegment(index).getStartAddress();
                            break;
                        }
                        case 1: 
                        case 5: {
                            targetAddr = groups.get(index - 1).getStartAddress();
                            break;
                        }
                        case 2: 
                        case 6: {
                            OmfSymbol symbol = this.externsyms.get(index - 1);
                            if (symbol.isFloatingPointSpecial()) continue block17;
                            targetAddr = symbol.getAddress().getOffset();
                            break;
                        }
                        default: {
                            log.appendMsg("Unsupported target method " + Integer.toString(method));
                            continue block17;
                        }
                    }
                    if (method < 3) {
                        targetAddr += (long)subrec.getTargetDisplacement();
                    }
                    locationType = subrec.getLocationType();
                    OmfSegmentHeader seg = header.resolveSegment(fixup.getDataBlock().getSegmentIndex());
                    locAddress = seg.getAddress(language).add(fixup.getDataBlock().getDataOffset() + (long)subrec.getDataRecordOffset());
                    if (locAddress == null) {
                        log.appendMsg("Couldn't find address for fixup");
                        continue;
                    }
                    finalvalue = targetAddr;
                    switch (locationType) {
                        case 0: {
                            origbytes = new byte[1];
                            memory.getBytes(locAddress, origbytes);
                            finalvalue = subrec.isSegmentRelative() ? (finalvalue += (long)origbytes[0]) : (finalvalue -= locAddress.getOffset() + 1L);
                            memory.setByte(locAddress, (byte)finalvalue);
                            break;
                        }
                        case 1: 
                        case 5: {
                            origbytes = new byte[2];
                            memory.getBytes(locAddress, origbytes);
                            finalvalue = subrec.isSegmentRelative() ? (finalvalue += (long)converter.getShort(origbytes)) : (finalvalue -= locAddress.getOffset() + 2L);
                            memory.setShort(locAddress, (short)finalvalue);
                            break;
                        }
                        case 2: {
                            if (!subrec.isSegmentRelative()) {
                                this.relocationError(program, log, locAddress, locationType);
                                continue block17;
                            }
                            origbytes = new byte[2];
                            memory.getBytes(locAddress, origbytes);
                            finalvalue += (long)(converter.getShort(origbytes) << 4);
                            memory.setShort(locAddress, (short)(finalvalue >>= 4));
                            break;
                        }
                        case 3: {
                            if (!subrec.isSegmentRelative()) {
                                this.relocationError(program, log, locAddress, locationType);
                                continue block17;
                            }
                            origbytes = new byte[4];
                            memory.getBytes(locAddress, origbytes);
                            finalvalue += (long)converter.getInt(origbytes);
                            finalvalue = (finalvalue & 0xFFFF0000L) << 12 | finalvalue & 0xFFFFL;
                            memory.setInt(locAddress, (int)finalvalue);
                            break;
                        }
                        case 4: 
                        case 9: 
                        case 13: {
                            origbytes = new byte[4];
                            memory.getBytes(locAddress, origbytes);
                            finalvalue = subrec.isSegmentRelative() ? (finalvalue += (long)converter.getInt(origbytes)) : (finalvalue -= locAddress.getOffset() + 4L);
                            memory.setInt(locAddress, (int)finalvalue);
                            break;
                        }
                        default: {
                            log.appendMsg("Unsupported relocation type " + Integer.toString(locationType) + " at 0x" + Long.toHexString(locAddress.getOffset()));
                            break;
                        }
                    }
                }
                catch (MemoryAccessException e) {
                    this.relocationError(program, log, locAddress, locationType);
                    continue;
                }
                catch (OmfException e) {
                    this.relocationError(program, log, locAddress, locationType);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    this.relocationError(program, log, locAddress, locationType);
                    continue;
                }
                long[] values = new long[]{finalvalue};
                program.getRelocationTable().add(locAddress, Relocation.Status.APPLIED, locationType, values, origbytes, null);
            }
        }
    }

    private void processSegmentHeaders(BinaryReader reader, OmfFileHeader header, Program program, TaskMonitor monitor, MessageLog log) throws AddressOverflowException, IOException {
        monitor.setMessage("Process segments...");
        Language language = program.getLanguage();
        List<OmfSegmentHeader> segments = header.getSegments();
        for (OmfSegmentHeader segment : segments) {
            if (monitor.isCancelled()) break;
            Address segmentAddr = segment.getAddress(language);
            long segmentSize = segment.getSegmentLength();
            if (segmentSize == 0L) continue;
            if (segment.hasNonZeroData()) {
                MemoryBlockUtils.createInitializedBlock(program, false, segment.getName(), segmentAddr, segment.getRawDataStream(reader, log), segmentSize, "", "", segment.isReadable(), segment.isWritable(), segment.isExecutable(), log, monitor);
                continue;
            }
            MemoryBlockUtils.createUninitializedBlock(program, false, segment.getName(), segmentAddr, segmentSize, "", "", segment.isReadable(), segment.isWritable(), segment.isExecutable(), log);
        }
    }

    private Address findFreeAddress(Program program) {
        MemoryBlock[] blocks;
        Memory memory = program.getMemory();
        Address maxAddr = memory.getMinAddress();
        if (maxAddr == null) {
            return null;
        }
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            Address blockEnd = block.getEnd().getPhysicalAddress();
            if (blockEnd.compareTo((Object)maxAddr) <= 0) continue;
            maxAddr = blockEnd;
        }
        Address externAddress = null;
        long newOffset = maxAddr.getOffset() + 4096L & 0xFFFFFFFFFFFFF000L;
        externAddress = maxAddr.getNewAddress(newOffset);
        return externAddress;
    }

    private void processPublicSymbols(OmfFileHeader header, Program program, TaskMonitor monitor, MessageLog log) {
        SymbolTable symbolTable = program.getSymbolTable();
        List<OmfSymbolRecord> symbols = header.getPublicSymbols();
        List<OmfSegmentHeader> segments = header.getSegments();
        List<OmfGroupRecord> groups = header.getGroups();
        Language language = program.getLanguage();
        monitor.setMessage("Creating Public Symbols");
        for (OmfSymbolRecord symbolrec : symbols) {
            if (monitor.isCancelled()) break;
            Address addrBase = null;
            boolean tagFunction = false;
            if (symbolrec.getSegmentIndex() != 0) {
                OmfSegmentHeader baseSegment = segments.get(symbolrec.getSegmentIndex() - 1);
                addrBase = baseSegment.getAddress(language);
                tagFunction = baseSegment.isCode();
            } else if (symbolrec.getGroupIndex() != 0) {
                OmfGroupRecord baseGroup = groups.get(symbolrec.getGroupIndex() - 1);
                addrBase = baseGroup.getAddress(language);
            } else {
                addrBase = language.getDefaultSpace().getAddress(0L);
            }
            int numSymbols = symbolrec.numSymbols();
            for (int i = 0; i < numSymbols; ++i) {
                OmfSymbol symbol = symbolrec.getSymbol(i);
                try {
                    Address address = addrBase.add(symbol.getOffset());
                    symbol.setAddress(address);
                    this.createSymbol(symbol, address, symbolTable, log);
                    if (!tagFunction) continue;
                    try {
                        program.getFunctionManager().createFunction(symbol.getName(), address, (AddressSetView)new AddressSet(address), SourceType.IMPORTED);
                    }
                    catch (OverlappingFunctionException e) {
                        log.appendMsg("Function already exists at address " + String.valueOf(address) + ": " + e.getMessage());
                    }
                    catch (InvalidInputException e) {
                        log.appendMsg("Unable to create function with invalid name " + symbol.getName() + ": " + e.getMessage());
                    }
                    continue;
                }
                catch (AddressOutOfBoundsException e) {
                    log.appendMsg("Unable to create symbol " + symbol.getName() + ": " + e.getMessage());
                }
            }
        }
    }

    private boolean createSymbol(OmfSymbol symbol, Address address, SymbolTable symbolTable, MessageLog log) {
        Symbol existingSym = symbolTable.getPrimarySymbol(address);
        String name = symbol.getName();
        Symbol sym = symbolTable.getGlobalSymbol(name, address);
        if (sym == null) {
            try {
                sym = symbolTable.createLabel(address, name, SourceType.IMPORTED);
            }
            catch (InvalidInputException e) {
                log.appendMsg("Unable to create symbol " + symbol.getName() + " at 0x" + Long.toHexString(address.getOffset()));
                return false;
            }
        }
        if (existingSym == null || !existingSym.isPrimary()) {
            sym.setPrimary();
        }
        return true;
    }

    private void processExternalSymbols(OmfFileHeader header, Program program, TaskMonitor monitor, MessageLog log) {
        List<OmfExternalSymbol> symbolrecs = header.getExternalSymbols();
        if (symbolrecs.size() == 0) {
            return;
        }
        Address externalAddress = this.findFreeAddress(program);
        if (externalAddress == null) {
            log.appendMsg("Serious problem, there is no memory at all for symbols!");
            return;
        }
        Address externalAddressStart = externalAddress;
        SymbolTable symbolTable = program.getSymbolTable();
        Language language = program.getLanguage();
        Map publicSymbols = header.getPublicSymbols().stream().flatMap(symbolRec -> symbolRec.getSymbols().stream()).collect(Collectors.toMap(sym -> sym.getName(), Function.identity()));
        monitor.setMessage("Creating External Symbols");
        block0: for (OmfExternalSymbol symbolrec : symbolrecs) {
            for (OmfSymbol symbol : symbolrec.getSymbols()) {
                if (monitor.isCancelled()) continue block0;
                OmfSymbol public_symbol = (OmfSymbol)publicSymbols.get(symbol.getName());
                if (public_symbol != null) {
                    this.externsyms.add(public_symbol);
                    continue;
                }
                Address address = null;
                if (symbol.getSegmentRef() != 0) {
                    OmfSegmentHeader segment = header.getExtraSegments().get(symbol.getSegmentRef() - 1);
                    address = segment.getAddress(language);
                    symbol.setAddress(address);
                    this.externsyms.add(symbol);
                    this.createSymbol(symbol, address, symbolTable, log);
                    continue;
                }
                address = externalAddress;
                symbol.setAddress(address);
                this.externsyms.add(symbol);
                if (!this.createSymbol(symbol, address, symbolTable, log)) continue;
                externalAddress = externalAddress.add(16L);
            }
        }
        this.createExternalBlock(program, log, externalAddress, externalAddressStart);
    }

    private void createExternalBlock(Program program, MessageLog log, Address externalAddress, Address externalAddressStart) {
        if (!externalAddressStart.equals((Object)externalAddress)) {
            long size = externalAddress.subtract(externalAddressStart);
            try {
                MemoryBlock block = program.getMemory().createUninitializedBlock("EXTERNAL", externalAddressStart, size, false);
                block.setWrite(true);
                block.setArtificial(true);
                Address current = externalAddressStart;
                while (current.compareTo((Object)externalAddress) < 0) {
                    this.createUndefined(program.getListing(), program.getMemory(), current, externalAddress.getAddressSpace().getPointerSize());
                    current = current.add((long)externalAddress.getAddressSpace().getPointerSize());
                }
            }
            catch (Exception e) {
                log.appendMsg("Error creating external memory block:  - " + e.getMessage());
            }
        }
    }

    private Data createUndefined(Listing listing, Memory memory, Address addr, int size) throws CodeUnitInsertionException {
        MemoryBlock block = memory.getBlock(addr);
        if (block == null || !block.isInitialized()) {
            return null;
        }
        DataType undefined = Undefined.getUndefinedDataType((int)size);
        return listing.createData(addr, undefined);
    }
}

