/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.StrutFieldElement;
import docking.widgets.fieldpanel.field.TextField;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.app.util.XReferenceUtils;
import ghidra.app.util.query.TableService;
import ghidra.app.util.viewer.field.FieldMouseHandlerExtension;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.XRefFieldLocation;
import ghidra.program.util.XRefHeaderFieldLocation;
import java.awt.event.MouseEvent;
import java.util.Set;

public class XRefFieldMouseHandler
implements FieldMouseHandlerExtension {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{XRefFieldLocation.class, XRefHeaderFieldLocation.class};

    @Override
    public boolean fieldElementClicked(Object clickedObject, Navigatable sourceNavigatable, ProgramLocation location, MouseEvent mouseEvent, ServiceProvider serviceProvider) {
        if (mouseEvent.getClickCount() != 2 || mouseEvent.getButton() != 1) {
            return false;
        }
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        if (goToService == null) {
            return false;
        }
        if (this.isXREFHeaderLocation(location)) {
            this.showXRefDialog(sourceNavigatable, location, serviceProvider);
            return true;
        }
        Address referencedAddress = this.getFromReferenceAddress(location);
        boolean isInvisibleXRef = this.isInvisibleXRef(clickedObject);
        if (isInvisibleXRef) {
            this.showXRefDialog(sourceNavigatable, location, serviceProvider);
            return true;
        }
        return this.goTo(sourceNavigatable, referencedAddress, goToService);
    }

    private boolean isInvisibleXRef(Object clickedObject) {
        String clickedText = this.getText(clickedObject);
        if ("[more]".equals(clickedText)) {
            return true;
        }
        return clickedObject instanceof StrutFieldElement;
    }

    protected boolean isXREFHeaderLocation(ProgramLocation location) {
        return location instanceof XRefHeaderFieldLocation;
    }

    private String getText(Object clickedObject) {
        if (clickedObject instanceof TextField) {
            TextField textField = (TextField)clickedObject;
            return textField.getText();
        }
        if (clickedObject instanceof FieldElement) {
            FieldElement fieldElement = (FieldElement)clickedObject;
            return fieldElement.getText();
        }
        return clickedObject.toString();
    }

    protected Address getFromReferenceAddress(ProgramLocation programLocation) {
        return ((XRefFieldLocation)programLocation).getRefAddress();
    }

    protected void showXRefDialog(Navigatable navigatable, ProgramLocation location, ServiceProvider serviceProvider) {
        TableService service = (TableService)serviceProvider.getService(TableService.class);
        if (service == null) {
            return;
        }
        Set<Reference> refs = XReferenceUtils.getAllXrefs(location);
        XReferenceUtils.showXrefs(navigatable, serviceProvider, service, location, refs);
    }

    private boolean goTo(Navigatable navigatable, Address referencedAddress, GoToService goToService) {
        if (referencedAddress != null) {
            return goToService.goTo(navigatable, referencedAddress);
        }
        return false;
    }

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }
}

