/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.DuplicateGroupException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.datastruct.Stack;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.List;

class ProgramTreeXmlMgr {
    private Listing listing;
    private MessageLog log;
    private AddressFactory factory;
    private List<String> fragmentNameList;
    private Stack<ProgramModule> moduleStack;
    private String treeName;
    private TaskMonitor monitor;

    ProgramTreeXmlMgr(Program program, MessageLog log) {
        this.log = log;
        this.listing = program.getListing();
        this.factory = program.getAddressFactory();
        this.moduleStack = new Stack();
    }

    void read(XmlPullParser parser, TaskMonitor m, boolean addToProgram) throws CancelledException {
        this.monitor = m;
        if (!addToProgram) {
            this.listing.removeTree("Program Tree");
        }
        XmlElement trees = parser.start(new String[]{"PROGRAM_TREES"});
        while (parser.peek().isStart()) {
            if (m.isCancelled()) {
                throw new CancelledException();
            }
            XmlElement element = null;
            try {
                element = parser.next();
                this.processTree(element, parser);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
                parser.discardSubTree(element);
            }
        }
        parser.end(trees);
    }

    void write(XmlWriter writer, AddressSetView addrs, TaskMonitor m) throws CancelledException {
        String[] treeNames;
        this.monitor = m;
        m.setMessage("Writing PROGRAM TREES ...");
        writer.startElement("PROGRAM_TREES");
        for (String treeName2 : treeNames = this.listing.getTreeNames()) {
            if (m.isCancelled()) {
                throw new CancelledException();
            }
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("NAME", treeName2);
            writer.startElement("TREE", attrs);
            ProgramModule root = this.listing.getRootModule(treeName2);
            ArrayList<ProgramModule> writtenModules = new ArrayList<ProgramModule>();
            ArrayList<ProgramFragment> writtenFragments = new ArrayList<ProgramFragment>();
            this.writeModule(writer, addrs, root, writtenModules, writtenFragments);
            writer.endElement("TREE");
        }
        writer.endElement("PROGRAM_TREES");
    }

    private void processTree(XmlElement treeElement, XmlPullParser parser) {
        this.treeName = treeElement.getAttribute("NAME");
        this.fragmentNameList = new ArrayList<String>();
        ProgramModule root = null;
        try {
            String elementName;
            try {
                root = this.listing.createRootModule(this.treeName);
            }
            catch (DuplicateNameException dne) {
                int oneUp = 1;
                while (true) {
                    try {
                        root = this.listing.createRootModule(this.treeName + "(" + oneUp + ")");
                    }
                    catch (DuplicateNameException e) {
                        ++oneUp;
                        continue;
                    }
                    break;
                }
                this.treeName = root.getTreeName();
            }
            this.moduleStack.push((Object)root);
            XmlElement element = parser.next();
            while (!this.monitor.isCancelled() && ((elementName = element.getName()).equals("FRAGMENT") || elementName.equals("MODULE") || elementName.equals("FOLDER"))) {
                if (elementName.equals("FRAGMENT")) {
                    if (element.isStart()) {
                        this.processFragment(element, parser);
                    }
                } else if (element.isStart()) {
                    this.processModule(element, parser);
                } else {
                    this.moduleStack.pop();
                }
                element = parser.next();
            }
            this.removeEmptyFragments(root);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
            parser.discardSubTree(treeElement);
        }
    }

    private void processModule(XmlElement element, XmlPullParser parser) {
        String name = element.getAttribute("NAME");
        ProgramModule parent = (ProgramModule)this.moduleStack.peek();
        ProgramModule newModule = null;
        try {
            try {
                newModule = parent.createModule(name);
            }
            catch (DuplicateNameException dne) {
                newModule = this.listing.getModule(this.treeName, name);
                parent.add(newModule);
            }
            this.moduleStack.push((Object)newModule);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
            parser.discardSubTree(element);
        }
    }

    private void processFragment(XmlElement element, XmlPullParser parser) {
        String name = element.getAttribute("NAME");
        if (!this.fragmentNameList.contains(name)) {
            this.fragmentNameList.add(name);
        }
        ProgramModule parent = (ProgramModule)this.moduleStack.peek();
        ProgramFragment frag = null;
        try {
            frag = parent.createFragment(name);
        }
        catch (DuplicateNameException dne) {
            frag = this.listing.getFragment(this.treeName, name);
            try {
                parent.add(frag);
            }
            catch (DuplicateGroupException duplicateGroupException) {
                // empty catch block
            }
        }
        try {
            this.processFragmentRange(frag, parser);
        }
        catch (NotFoundException e) {
            this.log.appendMsg(e.getMessage());
            parser.discardSubTree(element);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
            parser.discardSubTree(element);
        }
    }

    private void processFragmentRange(ProgramFragment frag, XmlPullParser parser) throws AddressFormatException, NotFoundException {
        XmlElement element = parser.next();
        while (!this.monitor.isCancelled()) {
            String elementName = element.getName();
            if (elementName.equals("ADDRESS_RANGE")) {
                if (element.isStart()) {
                    String startStr = element.getAttribute("START");
                    String endStr = element.getAttribute("END");
                    Address start = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)startStr);
                    Address end = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)endStr);
                    if (start == null || end == null) {
                        throw new AddressFormatException("Incompatible Fragment Address Range: [" + startStr + "," + endStr + "]");
                    }
                    frag.move(start, end);
                }
                element = parser.next();
                continue;
            }
            return;
        }
    }

    private void removeEmptyFragments(ProgramModule module) {
        Group[] groups;
        for (Group group : groups = module.getChildren()) {
            if (group instanceof ProgramFragment) {
                String name = group.getName();
                if (this.fragmentNameList.contains(name)) continue;
                try {
                    module.removeChild(name);
                }
                catch (NotEmptyException e) {
                    this.log.appendMsg("Warning: Extra Program Tree fragment '" + name + "' did not exist in imported XML file");
                }
                continue;
            }
            this.removeEmptyFragments((ProgramModule)group);
        }
    }

    private void writeModule(XmlWriter writer, AddressSetView addrs, ProgramModule parent, ArrayList<ProgramModule> writtenModules, ArrayList<ProgramFragment> writtenFragments) {
        XmlAttributes attrs = new XmlAttributes();
        boolean writeTag = false;
        if (parent != this.listing.getRootModule(parent.getTreeName())) {
            writeTag = true;
            attrs.addAttribute("NAME", parent.getName());
            writer.startElement("FOLDER", attrs);
        }
        if (!writtenModules.contains(parent)) {
            Group[] kids;
            writtenModules.add(parent);
            for (Group kid : kids = parent.getChildren()) {
                if (kid instanceof ProgramModule) {
                    this.writeModule(writer, addrs, (ProgramModule)kid, writtenModules, writtenFragments);
                    continue;
                }
                this.writeFragment(writer, addrs, (ProgramFragment)kid, writtenFragments);
            }
        }
        if (writeTag) {
            writer.endElement("FOLDER");
        }
    }

    private void writeFragment(XmlWriter writer, AddressSetView addrs, ProgramFragment fragment, ArrayList<ProgramFragment> writtenFragments) {
        if (fragment == null) {
            return;
        }
        AddressSet fragmentSet = addrs.intersect((AddressSetView)fragment);
        if (fragmentSet.isEmpty()) {
            return;
        }
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("NAME", fragment.getName());
        writer.startElement("FRAGMENT", attrs);
        if (!writtenFragments.contains(fragment)) {
            writtenFragments.add(fragment);
            this.writeFragmentRange(writer, fragment, (AddressSetView)fragmentSet);
        }
        writer.endElement("FRAGMENT");
    }

    private void writeFragmentRange(XmlWriter writer, ProgramFragment fragment, AddressSetView fragmentSet) {
        AddressRangeIterator iter = fragmentSet.getAddressRanges();
        while (iter.hasNext()) {
            XmlAttributes attrs = new XmlAttributes();
            AddressRange range = (AddressRange)iter.next();
            attrs.addAttribute("START", XmlProgramUtilities.toString((Address)range.getMinAddress()));
            attrs.addAttribute("END", XmlProgramUtilities.toString((Address)range.getMaxAddress()));
            writer.startElement("ADDRESS_RANGE", attrs);
            writer.endElement("ADDRESS_RANGE");
        }
    }
}

