/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.bytesource;

import ghidra.features.base.memsearch.bytesource.SearchRegion;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import java.util.List;

public enum ProgramSearchRegion implements SearchRegion
{
    LOADED("Loaded Blocks", "Searches all memory blocks that represent loaded program instructions and data"){

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public AddressSetView getAddresses(Program program) {
            Memory memory = program.getMemory();
            return memory.getLoadedAndInitializedAddressSet();
        }
    }
    ,
    OTHER("All Other Blocks", "Searches non-loaded initialized blocks"){

        @Override
        public boolean isDefault() {
            return false;
        }

        @Override
        public AddressSetView getAddresses(Program program) {
            Memory memory = program.getMemory();
            AddressSetView all = memory.getAllInitializedAddressSet();
            AddressSetView loaded = memory.getLoadedAndInitializedAddressSet();
            return all.subtract(loaded);
        }
    };

    public static final List<SearchRegion> ALL;
    private String name;
    private String description;

    private ProgramSearchRegion(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static {
        ALL = List.of(ProgramSearchRegion.values());
    }
}

