/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import docking.DockingUtils;
import docking.menu.ButtonState;
import docking.menu.MultiStateButton;
import docking.widgets.PopupWindow;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.list.GComboBoxCellRenderer;
import generic.theme.GThemeDefaults;
import ghidra.features.base.memsearch.combiner.Combiner;
import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.gui.MemorySearchProvider;
import ghidra.features.base.memsearch.gui.SearchGuiModel;
import ghidra.features.base.memsearch.gui.SearchHistory;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import ghidra.features.base.memsearch.matcher.InvalidByteMatcher;
import ghidra.util.HTMLUtilities;
import ghidra.util.Swing;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;

class MemorySearchControlPanel
extends JPanel {
    private MultiStateButton<Combiner> searchButton;
    private GhidraComboBox<ByteMatcher> searchInputField;
    private GDLabel hexSearchSequenceField;
    private boolean hasResults;
    private ByteMatcher currentMatcher = new InvalidByteMatcher("");
    private SearchHistory searchHistory;
    private SearchGuiModel model;
    private JCheckBox selectionCheckbox;
    private boolean isBusy;
    private MemorySearchProvider provider;
    private List<ButtonState<Combiner>> initialSearchButtonStates;
    private List<ButtonState<Combiner>> combinerSearchButtonStates;
    private JComboBox<SearchFormat> formatComboBox;
    private PopupWindow popup;
    private String errorMessage;
    private GTimerMonitor clearInputMonitor;

    MemorySearchControlPanel(MemorySearchProvider provider, SearchGuiModel model, SearchHistory history) {
        super(new BorderLayout());
        this.provider = provider;
        this.searchHistory = history;
        this.model = model;
        model.addChangeCallback(this::guiModelChanged);
        this.initialSearchButtonStates = this.createButtonStatesForInitialSearch();
        this.combinerSearchButtonStates = this.createButtonStatesForAdditionSearches();
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.add((Component)this.buildLeftSearchInputPanel(), "Center");
        this.add((Component)this.buildRightSearchInputPanel(), "East");
    }

    private JComponent buildRightSearchInputPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.searchButton = new MultiStateButton(this.initialSearchButtonStates);
        this.searchButton.setStateChangedListener(state -> this.model.setMatchCombiner((Combiner)((Object)((Object)state.getClientData()))));
        this.searchButton.addActionListener(e -> this.search());
        panel.add((Component)this.searchButton, "West");
        this.selectionCheckbox = new JCheckBox("Selection Only");
        this.selectionCheckbox.setSelected(this.model.isSearchSelectionOnly());
        this.selectionCheckbox.setEnabled(this.model.hasSelection());
        this.selectionCheckbox.setToolTipText("If selected, search will be restricted to selected addresses");
        this.selectionCheckbox.addActionListener(e -> this.model.setSearchSelectionOnly(this.selectionCheckbox.isSelected()));
        panel.add(this.selectionCheckbox);
        this.searchButton.setEnabled(false);
        return panel;
    }

    private List<ButtonState<Combiner>> createButtonStatesForAdditionSearches() {
        ArrayList<ButtonState<Combiner>> states = new ArrayList<ButtonState<Combiner>>();
        states.add(new ButtonState("New Search", "New Search", "Replaces the current results with the new search results", (Object)Combiner.REPLACE));
        states.add(new ButtonState("Add To Search", "A union B", "Adds the results of the new search to the existing results", (Object)Combiner.UNION));
        states.add(new ButtonState("Intersect Search", "A intersect B", "Keep results that in both the existing and new results", (Object)Combiner.INTERSECT));
        states.add(new ButtonState("Xor Search", "A xor B", "Keep results that are in either existig or results, but not both", (Object)Combiner.XOR));
        states.add(new ButtonState("A-B Search", "A - B", "Subtracts the new results from the existing results", (Object)Combiner.A_MINUS_B));
        states.add(new ButtonState("B-A Search", "B - A", "Subtracts the existing results from the new results.", (Object)Combiner.B_MINUS_A));
        return states;
    }

    private List<ButtonState<Combiner>> createButtonStatesForInitialSearch() {
        ArrayList<ButtonState<Combiner>> states = new ArrayList<ButtonState<Combiner>>();
        states.add(new ButtonState("Search", "", "Perform a search for the entered values.", null));
        return states;
    }

    private void guiModelChanged(SearchSettings oldSettings) {
        SearchFormat searchFormat = this.model.getSearchFormat();
        if (!this.formatComboBox.getSelectedItem().equals(searchFormat)) {
            this.formatComboBox.setSelectedItem(searchFormat);
        }
        this.selectionCheckbox.setSelected(this.model.isSearchSelectionOnly());
        this.selectionCheckbox.setEnabled(this.model.hasSelection());
        this.searchInputField.setToolTipText(searchFormat.getToolTip());
        String text = this.searchInputField.getText();
        String convertedText = searchFormat.convertText(text, oldSettings, this.model.getSettings());
        this.searchInputField.setText(convertedText);
        ByteMatcher byteMatcher = searchFormat.parse(convertedText, this.model.getSettings());
        this.setByteMatcher(byteMatcher);
    }

    private JComponent buildLeftSearchInputPanel() {
        this.createSearchInputField();
        this.hexSearchSequenceField = new GDLabel();
        this.hexSearchSequenceField.setName("HexSequenceField");
        Border outerBorder = BorderFactory.createLoweredBevelBorder();
        Border innerBorder = BorderFactory.createEmptyBorder(0, 4, 0, 4);
        CompoundBorder border = BorderFactory.createCompoundBorder(outerBorder, innerBorder);
        this.hexSearchSequenceField.setBorder((Border)border);
        JPanel panel = new JPanel((LayoutManager)new PairLayout(2, 10));
        panel.add(this.buildSearchFormatCombo());
        panel.add((Component)this.searchInputField);
        JLabel byteSequenceLabel = new JLabel("Byte Sequence:", 4);
        byteSequenceLabel.setToolTipText("This field shows the byte sequence that will be search (if applicable)");
        panel.add(byteSequenceLabel);
        panel.add((Component)this.hexSearchSequenceField);
        return panel;
    }

    private void createSearchInputField() {
        this.searchInputField = new GhidraComboBox<ByteMatcher>(){

            public void setSelectedItem(Object obj) {
                if (obj instanceof String) {
                    return;
                }
                ByteMatcher matcher = (ByteMatcher)obj;
                MemorySearchControlPanel.this.model.setSettings(matcher.getSettings());
                super.setSelectedItem(obj);
            }
        };
        this.updateCombo();
        this.searchInputField.setAutoCompleteEnabled(false);
        this.searchInputField.setEditable(true);
        this.searchInputField.setToolTipText(this.model.getSearchFormat().getToolTip());
        this.searchInputField.setDocument((Document)new RestrictedInputDocument());
        this.searchInputField.addActionListener(ev -> this.search());
        JTextField searchTextField = this.searchInputField.getTextField();
        searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    MemorySearchControlPanel.this.clearInputError();
                    e.consume();
                }
            }
        });
        searchTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                MemorySearchControlPanel.this.clearInputError();
            }
        });
        this.searchInputField.setRenderer((ListCellRenderer)((Object)new SearchHistoryRenderer()));
    }

    private boolean canSearch() {
        return !this.isBusy && this.currentMatcher.isValidSearch();
    }

    private void search() {
        if (this.canSearch()) {
            this.provider.search();
            this.searchHistory.addSearch(this.currentMatcher);
            this.updateCombo();
        }
    }

    private JComponent buildSearchFormatCombo() {
        this.formatComboBox = new JComboBox<SearchFormat>(SearchFormat.ALL);
        this.formatComboBox.setSelectedItem(this.model.getSearchFormat());
        this.formatComboBox.addItemListener(this::formatComboChanged);
        this.formatComboBox.setToolTipText("The selected format will determine how to interpret text typed into the input field");
        return this.formatComboBox;
    }

    private void formatComboChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        SearchFormat newFormat = (SearchFormat)e.getItem();
        SearchSettings oldSettings = this.model.getSettings();
        SearchSettings newSettings = oldSettings.withSearchFormat(newFormat);
        String newText = this.convertInput(oldSettings, newSettings);
        this.model.setSearchFormat(newFormat);
        this.searchInputField.setText(newText);
    }

    String convertInput(SearchSettings oldSettings, SearchSettings newSettings) {
        String text = this.searchInputField.getText();
        SearchFormat newFormat = newSettings.getSearchFormat();
        return newFormat.convertText(text, oldSettings, newSettings);
    }

    private void setByteMatcher(ByteMatcher byteMatcher) {
        this.clearInputError();
        this.currentMatcher = byteMatcher;
        String text = this.currentMatcher.getDescription();
        this.hexSearchSequenceField.setText(text);
        this.hexSearchSequenceField.setToolTipText(this.currentMatcher.getToolTip());
        this.updateSearchButton();
        this.provider.setByteMatcher(byteMatcher);
    }

    void setSearchStatus(boolean hasResults, boolean isBusy) {
        this.hasResults = hasResults;
        this.isBusy = isBusy;
        this.updateSearchButton();
    }

    private void updateSearchButton() {
        this.searchButton.setEnabled(this.canSearch());
        if (!this.hasResults) {
            this.searchButton.setButtonStates(this.initialSearchButtonStates);
            return;
        }
        Combiner combiner = this.model.getMatchCombiner();
        this.searchButton.setButtonStates(this.combinerSearchButtonStates);
        this.searchButton.setSelectedStateByClientData((Object)combiner);
    }

    void setSearchCombiner(Combiner combiner) {
        this.searchButton.setSelectedStateByClientData((Object)combiner);
    }

    private void adjustLocationForCaretPosition(Point location) {
        JTextField textField = this.searchInputField.getTextField();
        Caret caret = textField.getCaret();
        Point p = caret.getMagicCaretPosition();
        if (p != null) {
            location.x += p.x;
        }
    }

    private void reportInputError(String message) {
        this.errorMessage = message;
        Swing.runLater(this::popupErrorMessage);
    }

    private void popupErrorMessage() {
        if (this.errorMessage == null) {
            return;
        }
        DockingUtils.setTipWindowEnabled((boolean)false);
        Point location = this.searchInputField.getLocation();
        this.adjustLocationForCaretPosition(location);
        location.y += this.searchInputField.getHeight() + 5;
        JToolTip tip = new JToolTip();
        tip.setTipText(this.errorMessage);
        this.errorMessage = null;
        if (this.popup != null) {
            this.popup.dispose();
            this.clearInputMonitor.cancel();
        }
        this.popup = new PopupWindow((JComponent)tip);
        this.popup.showPopup((Component)this.searchInputField.getParent(), location, true);
        this.clearInputMonitor = GTimer.scheduleRunnable((long)2000L, this::clearInputError);
        Toolkit.getDefaultToolkit().beep();
    }

    private void clearInputError() {
        this.errorMessage = null;
        DockingUtils.setTipWindowEnabled((boolean)true);
        PopupWindow.hideAllWindows();
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
            this.clearInputMonitor.cancel();
            this.clearInputMonitor = null;
        }
    }

    private void updateCombo() {
        ByteMatcher[] historyArray = this.searchHistory.getHistoryAsArray();
        this.searchInputField.setModel(new DefaultComboBoxModel<ByteMatcher>(historyArray));
    }

    void setSearchInput(String initialInput) {
        this.searchInputField.setText(initialInput);
    }

    Component getDefaultFocusComponent() {
        return this.searchInputField;
    }

    public class RestrictedInputDocument
    extends DefaultStyledDocument {
        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String afterOffset;
            str = this.removeNumberBasePrefixAndSuffix(str);
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String proposedText = beforeOffset + str + (afterOffset = currentText.substring(offs, currentText.length()));
            ByteMatcher byteMatcher = MemorySearchControlPanel.this.model.parse(proposedText);
            if (!byteMatcher.isValidInput()) {
                MemorySearchControlPanel.this.reportInputError(byteMatcher.getDescription());
                return;
            }
            super.insertString(offs, str, a);
            MemorySearchControlPanel.this.setByteMatcher(byteMatcher);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            MemorySearchControlPanel.this.clearInputError();
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(len + offs, currentText.length());
            String proposedResult = beforeOffset + afterOffset;
            if (proposedResult.length() == 0) {
                super.remove(offs, len);
                MemorySearchControlPanel.this.setByteMatcher(new InvalidByteMatcher(""));
                return;
            }
            ByteMatcher byteMatcher = MemorySearchControlPanel.this.model.parse(proposedResult);
            if (!byteMatcher.isValidInput()) {
                MemorySearchControlPanel.this.reportInputError(byteMatcher.getDescription());
                return;
            }
            super.remove(offs, len);
            MemorySearchControlPanel.this.setByteMatcher(byteMatcher);
        }

        private String removeNumberBasePrefixAndSuffix(String str) {
            SearchFormat format = MemorySearchControlPanel.this.model.getSearchFormat();
            if (format != SearchFormat.HEX && format != SearchFormat.BINARY) {
                return str;
            }
            String numMaybe = str.strip();
            String lowercase = numMaybe.toLowerCase();
            if (format == SearchFormat.HEX) {
                if (lowercase.startsWith("0x")) {
                    numMaybe = numMaybe.substring(2);
                } else if (lowercase.startsWith("$")) {
                    numMaybe = numMaybe.substring(1);
                } else if (lowercase.endsWith("h")) {
                    numMaybe = numMaybe.substring(0, numMaybe.length() - 1);
                }
            } else if (lowercase.startsWith("0b")) {
                numMaybe = numMaybe.substring(2);
            }
            if (!numMaybe.isEmpty()) {
                return numMaybe;
            }
            return str;
        }
    }

    private class SearchHistoryRenderer
    extends GComboBoxCellRenderer<ByteMatcher> {
        private SearchHistoryRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        public Component getListCellRendererComponent(JList<? extends ByteMatcher> list, ByteMatcher matcher, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, (Object)matcher, index, isSelected, cellHasFocus);
            Font font = this.getFont();
            int formatSize = Math.max(font.getSize() - 3, 6);
            SearchFormat format = matcher.getSettings().getSearchFormat();
            String formatHint = HTMLUtilities.setFontSize((String)format.getName(), (int)formatSize);
            if (!isSelected) {
                formatHint = HTMLUtilities.colorString((Color)GThemeDefaults.Colors.Messages.HINT, (String)formatHint);
            }
            this.setText("<html>" + matcher.getInput() + " <I>" + formatHint + "</I>");
            return this;
        }
    }
}

