/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.crypto;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.crypto.CryptoProvider;
import ghidra.formats.gfilesystem.crypto.PasswordProvider;
import ghidra.framework.generic.auth.Password;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class CachedPasswordProvider
implements PasswordProvider {
    private Map<String, List<CryptoRec>> values = new HashMap<String, List<CryptoRec>>();
    private int count;

    public synchronized void addPassword(FSRL fsrl, Password password) {
        CryptoRec rec = new CryptoRec();
        rec.fsrl = fsrl;
        rec.value = password.clone();
        this.addRec(rec);
    }

    private void addRec(CryptoRec rec) {
        String fsrlStr = rec.fsrl.toString();
        boolean isNewValue = this.addIfUnique(this.values.computeIfAbsent(fsrlStr, x -> new ArrayList()), rec);
        String fsrlStr2 = rec.fsrl.toPrettyString();
        if (!fsrlStr2.equals(fsrlStr)) {
            this.addIfUnique(this.values.computeIfAbsent(fsrlStr2, x -> new ArrayList()), rec);
        }
        this.addIfUnique(this.values.computeIfAbsent(rec.fsrl.getName(), x -> new ArrayList()), rec);
        if (rec.fsrl.getMD5() != null) {
            this.addIfUnique(this.values.computeIfAbsent(rec.fsrl.getMD5(), x -> new ArrayList()), rec);
        }
        if (isNewValue) {
            ++this.count;
        }
    }

    private boolean addIfUnique(List<CryptoRec> recs, CryptoRec newRec) {
        for (CryptoRec rec : recs) {
            if (!rec.value.equals((Object)newRec.value)) continue;
            return false;
        }
        recs.add(newRec);
        return true;
    }

    public synchronized void clearCache() {
        this.values.clear();
        this.count = 0;
    }

    public synchronized int getCount() {
        return this.count;
    }

    @Override
    public synchronized Iterator<Password> getPasswordsFor(FSRL fsrl, String prompt, CryptoProvider.Session session) {
        LinkedHashSet uniqueFoundRecs = new LinkedHashSet();
        uniqueFoundRecs.addAll(this.values.getOrDefault(fsrl.toString(), Collections.emptyList()));
        uniqueFoundRecs.addAll(this.values.getOrDefault(fsrl.toPrettyString(), Collections.emptyList()));
        uniqueFoundRecs.addAll(this.values.getOrDefault(fsrl.getName(), Collections.emptyList()));
        if (fsrl.getMD5() != null) {
            uniqueFoundRecs.addAll(this.values.getOrDefault(fsrl.getMD5(), Collections.emptyList()));
        }
        ArrayList<Password> results = new ArrayList<Password>();
        for (CryptoRec rec : uniqueFoundRecs) {
            results.add(rec.value);
        }
        return new CloningPasswordIterator(this, results.iterator());
    }

    private static class CryptoRec {
        FSRL fsrl;
        Password value;

        private CryptoRec() {
        }
    }

    private class CloningPasswordIterator
    implements Iterator<Password> {
        Iterator<Password> delegate;

        CloningPasswordIterator(CachedPasswordProvider cachedPasswordProvider, Iterator<Password> it) {
            this.delegate = it;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Password next() {
            Password result = this.delegate.next();
            return result.clone();
        }
    }
}

