/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph;

import ghidra.program.model.symbol.RefType;
import ghidra.service.graph.GraphType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.WordUtils;

public abstract class ProgramGraphType
extends GraphType {
    private static Map<RefType, String> refTypeToEdgeTypeMap = new HashMap<RefType, String>();
    private static List<String> vertexTypes = new ArrayList<String>();
    private static List<String> edgeTypes = new ArrayList<String>();
    public static final String BODY = ProgramGraphType.vertex("Body");
    public static final String ENTRY = ProgramGraphType.vertex("Entry");
    public static final String EXIT = ProgramGraphType.vertex("Exit");
    public static final String SWITCH = ProgramGraphType.vertex("Switch");
    public static final String EXTERNAL = ProgramGraphType.vertex("External");
    public static final String BAD = ProgramGraphType.vertex("Bad");
    public static final String INSTRUCTION = ProgramGraphType.vertex("Instruction");
    public static final String DATA = ProgramGraphType.vertex("Data");
    public static final String ENTRY_NEXUS = ProgramGraphType.vertex("Entry-Nexus");
    public static final String STACK = ProgramGraphType.vertex("Stack");
    public static final String ENTRY_EDGE = ProgramGraphType.edge("Entry");
    public static final String FALL_THROUGH = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.FALL_THROUGH));
    public static final String UNCONDITIONAL_JUMP = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.UNCONDITIONAL_JUMP));
    public static final String UNCONDITIONAL_CALL = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.UNCONDITIONAL_CALL));
    public static final String TERMINATOR = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.TERMINATOR));
    public static final String JUMP_TERMINATOR = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.JUMP_TERMINATOR));
    public static final String INDIRECTION = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.INDIRECTION));
    public static final String CONDITIONAL_JUMP = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.CONDITIONAL_JUMP));
    public static final String CONDITIONAL_CALL = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.CONDITIONAL_CALL));
    public static final String CONDITIONAL_TERMINATOR = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.CONDITIONAL_TERMINATOR));
    public static final String CONDITIONAL_CALL_TERMINATOR = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.CONDITIONAL_CALL_TERMINATOR));
    public static final String COMPUTED_JUMP = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.COMPUTED_JUMP));
    public static final String COMPUTED_CALL = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.COMPUTED_CALL));
    public static final String COMPUTED_CALL_TERMINATOR = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.COMPUTED_CALL_TERMINATOR));
    public static final String CONDITIONAL_COMPUTED_CALL = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.CONDITIONAL_COMPUTED_CALL));
    public static final String CONDITIONAL_COMPUTED_JUMP = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.CONDITIONAL_COMPUTED_JUMP));
    public static final String CALL_OVERRIDE_UNCONDITIONAL = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.CALL_OVERRIDE_UNCONDITIONAL));
    public static final String JUMP_OVERRIDE_UNCONDITIONAL = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.CALL_OVERRIDE_UNCONDITIONAL));
    public static final String CALLOTHER_OVERRIDE_CALL = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.CALL_OVERRIDE_UNCONDITIONAL));
    public static final String CALLOTHER_OVERRIDE_JUMP = ProgramGraphType.edge(ProgramGraphType.map((RefType)RefType.CALL_OVERRIDE_UNCONDITIONAL));
    public static final String READ = ProgramGraphType.edge(ProgramGraphType.map(RefType.READ));
    public static final String WRITE = ProgramGraphType.edge(ProgramGraphType.map(RefType.WRITE));
    public static final String READ_WRITE = ProgramGraphType.edge(ProgramGraphType.map(RefType.READ_WRITE));
    public static final String UNKNOWN_DATA = ProgramGraphType.edge(ProgramGraphType.map(RefType.DATA));
    public static final String EXTERNAL_REF = ProgramGraphType.edge(ProgramGraphType.map(RefType.EXTERNAL_REF));
    public static final String READ_INDIRECT = ProgramGraphType.edge(ProgramGraphType.map(RefType.READ_IND));
    public static final String WRITE_INDIRECT = ProgramGraphType.edge(ProgramGraphType.map(RefType.WRITE_IND));
    public static final String READ_WRITE_INDIRECT = ProgramGraphType.edge(ProgramGraphType.map(RefType.READ_WRITE_IND));
    public static final String DATA_INDIRECT = ProgramGraphType.edge(ProgramGraphType.map(RefType.DATA_IND));
    public static final String PARAM = ProgramGraphType.edge(ProgramGraphType.map(RefType.PARAM));
    public static final String THUNK = ProgramGraphType.edge(ProgramGraphType.map(RefType.THUNK));

    protected ProgramGraphType(String name, String description) {
        super(name, description, vertexTypes, edgeTypes);
    }

    private static String vertex(String vertexType) {
        vertexTypes.add(vertexType);
        return vertexType;
    }

    private static String edge(String edgeType) {
        edgeTypes.add(edgeType);
        return edgeType;
    }

    private static String map(RefType refType) {
        String edgeTypeName = ProgramGraphType.fixup(refType.getName());
        refTypeToEdgeTypeMap.put(refType, edgeTypeName);
        return edgeTypeName;
    }

    private static String fixup(String name) {
        name = name.replace('_', ' ');
        return WordUtils.capitalizeFully((String)name);
    }

    public static String getEdgeType(RefType refType) {
        return refTypeToEdgeTypeMap.get(refType);
    }

    public String getOptionsName() {
        return "Program Graph Display Options";
    }
}

