/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util.string;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PascalString255DataType;
import ghidra.program.model.data.PascalStringDataType;
import ghidra.program.model.data.PascalUnicodeDataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;

public class FoundString
implements Comparable<FoundString> {
    private Address address;
    private int length;
    private DataType stringDataType;
    private DefinedState definedState = DefinedState.NOT_DEFINED;

    public FoundString(Address address, int length, DataType stringDataType) {
        this(address, length, stringDataType, DefinedState.NOT_DEFINED);
    }

    public FoundString(Address address, int length, DataType stringDataType, DefinedState definedState) {
        this.length = length;
        this.stringDataType = stringDataType;
        this.address = address;
        this.definedState = definedState;
    }

    public int getLength() {
        return this.length;
    }

    public Address getAddress() {
        return this.address;
    }

    public Address getEndAddress() {
        return this.address.add((long)(this.length - 1));
    }

    public boolean isUndefined() {
        return this.definedState == DefinedState.NOT_DEFINED;
    }

    public boolean isDefined() {
        return this.definedState == DefinedState.DEFINED;
    }

    public boolean isPartiallyDefined() {
        return this.definedState == DefinedState.PARTIALLY_DEFINED;
    }

    public boolean conflicts() {
        return this.definedState == DefinedState.CONFLICTS;
    }

    public String getString(Memory memory) {
        DumbMemBufferImpl membuf = new DumbMemBufferImpl(memory, this.address);
        return StringDataInstance.getStringDataInstance((DataType)this.stringDataType, (MemBuffer)membuf, (Settings)SettingsImpl.NO_SETTINGS, (int)this.length).getStringValue();
    }

    public StringDataInstance getDataInstance(Memory memory) {
        DumbMemBufferImpl membuf = new DumbMemBufferImpl(memory, this.address);
        return new StringDataInstance(this.stringDataType, SettingsImpl.NO_SETTINGS, (MemBuffer)membuf, this.length);
    }

    public void setDefinedState(DefinedState newState) {
        this.definedState = newState;
    }

    public DefinedState getDefinedState() {
        return this.definedState;
    }

    public boolean isPascall() {
        return this.stringDataType instanceof PascalStringDataType || this.stringDataType instanceof PascalString255DataType || this.stringDataType instanceof PascalUnicodeDataType;
    }

    public DataType getDataType() {
        return this.stringDataType;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FoundString other = (FoundString)obj;
        return this.address.equals((Object)other.getAddress());
    }

    @Override
    public int compareTo(FoundString other) {
        return this.address.compareTo((Object)other.address);
    }

    public int getStringLength(Memory mem) {
        StringDataInstance stringDataInstance = this.getDataInstance(mem);
        return stringDataInstance.getStringLength();
    }

    public String toString() {
        return "@" + String.valueOf(this.address) + ", length=" + this.length + ", state=" + String.valueOf((Object)this.definedState);
    }

    public static enum DefinedState {
        NOT_DEFINED,
        DEFINED,
        PARTIALLY_DEFINED,
        CONFLICTS;

    }
}

