/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.search.trie;

import ghidra.util.search.trie.ByteTrieNodeIfc;

public class ByteTrieNode<T>
implements ByteTrieNodeIfc<T> {
    private static final int TERMINAL_MASK = 256;
    private static final int ID_MASK = 255;
    ByteTrieNode<T>[] children = new ByteTrieNode[0];
    private short idAndTerminality;
    private final int length;
    private final ByteTrieNode<T> parent;
    ByteTrieNode<T> suffix;
    private T item;

    protected byte transformByte(byte v) {
        return v;
    }

    @Override
    public boolean isTerminal() {
        return (this.idAndTerminality & 0x100) != 0;
    }

    @Override
    public T getItem() {
        return this.item;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public byte[] getValue() {
        int count = 0;
        ByteTrieNode<T> node = this;
        while (node.parent != null) {
            ++count;
            node = node.parent;
        }
        byte[] result = new byte[count];
        int index = count - 1;
        node = this;
        while (node.parent != null) {
            result[index--] = node.getId();
            node = node.parent;
        }
        return result;
    }

    protected byte getId() {
        return (byte)(this.idAndTerminality & 0xFF);
    }

    public ByteTrieNode<T> getChild(byte value) {
        value = this.transformByte(value);
        if (this.children.length == 0) {
            return null;
        }
        if (this.children.length == 1) {
            if (this.transformByte(this.children[0].getId()) == value) {
                return this.children[0];
            }
            return null;
        }
        if (this.children.length == 2) {
            if (this.transformByte(this.children[0].getId()) == value) {
                return this.children[0];
            }
            if (this.transformByte(this.children[1].getId()) == value) {
                return this.children[1];
            }
            return null;
        }
        int index = this.findIndex(value);
        if (index >= this.children.length) {
            return null;
        }
        ByteTrieNode<T> child = this.children[index];
        if (this.transformByte(child.getId()) == value) {
            return child;
        }
        return null;
    }

    void addChild(byte value, ByteTrieNode<T> child) {
        int ii;
        value = this.transformByte(value);
        ByteTrieNode[] newChildren = new ByteTrieNode[this.children.length + 1];
        if (this.children.length == 0) {
            newChildren[0] = child;
            this.children = newChildren;
            return;
        }
        if (this.children.length == 1) {
            if (value < this.transformByte(this.children[0].getId())) {
                newChildren[0] = child;
                newChildren[1] = this.children[0];
            } else {
                newChildren[0] = this.children[0];
                newChildren[1] = child;
            }
            this.children = newChildren;
            return;
        }
        int newChildIndex = this.findIndex(value);
        for (ii = 0; ii < newChildIndex; ++ii) {
            newChildren[ii] = this.children[ii];
        }
        newChildren[newChildIndex] = child;
        for (ii = newChildIndex + 1; ii < newChildren.length; ++ii) {
            newChildren[ii] = this.children[ii - 1];
        }
        this.children = newChildren;
    }

    private int findIndex(byte value) {
        if (this.children.length == 0) {
            return 0;
        }
        int left = 0;
        int right = this.children.length;
        while (right >= left) {
            int mid = (left + right) / 2;
            if (mid >= this.children.length) {
                return mid;
            }
            ByteTrieNode<T> child = this.children[mid];
            byte id = this.transformByte(child.getId());
            if (id == value) {
                return mid;
            }
            if (id < value) {
                left = mid + 1;
                continue;
            }
            right = mid - 1;
        }
        return left;
    }

    ByteTrieNode(byte id, ByteTrieNode<T> parent, int length) {
        this.idAndTerminality = (short)(id & 0xFF);
        this.parent = parent;
        this.length = length;
    }

    void setTerminal(T item) {
        this.idAndTerminality = (short)(this.idAndTerminality | 0x100);
        this.item = item;
    }

    public String toString() {
        if (this.parent == null) {
            return (this.isTerminal() ? "*" : "") + "-";
        }
        return String.format((this.isTerminal() ? "*" : "") + "%s:%c  s:[%s]", ByteTrieNode.debugByteArray(this.getValue()), this.getId(), this.suffix);
    }

    private static String debugByteArray(byte[] array) {
        StringBuilder sb = new StringBuilder();
        for (byte b : array) {
            if (b > 31 && b < 127) {
                sb.append((char)b);
                continue;
            }
            sb.append(String.format("\\x%02x", (byte)(b & 0xFF)));
        }
        return sb.toString();
    }
}

