/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.debug.api.progress.CloseableTaskMonitor;
import ghidra.debug.api.progress.MonitorReceiver;
import ghidra.debug.api.progress.ProgressListener;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;

@ServiceInfo(defaultProviderName="ghidra.app.plugin.core.debug.service.progress.ProgressServicePlugin")
public interface ProgressService {
    public CloseableTaskMonitor publishTask();

    public Collection<MonitorReceiver> getAllMonitors();

    public void addProgressListener(ProgressListener var1);

    public void removeProgressListener(ProgressListener var1);

    default public CompletableFuture<Void> execute(Task task) {
        return CompletableFuture.supplyAsync(() -> {
            CloseableTaskMonitor monitor = this.publishTask();
            try {
                monitor.setCancelEnabled(task.canCancel());
                try {
                    task.run((TaskMonitor)monitor);
                }
                catch (CancelledException e) {
                    throw new CancellationException("User cancelled");
                }
                catch (Throwable e) {
                    monitor.reportError(e);
                    Void void_ = (Void)ExceptionUtils.rethrow((Throwable)e);
                    if (monitor != null) {
                        monitor.close();
                    }
                    return void_;
                }
                Void void_ = null;
                return void_;
            }
            finally {
                if (monitor != null) {
                    try {
                        monitor.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        });
    }

    default public <T> CompletableFuture<T> execute(boolean canCancel, boolean hasProgress, boolean isModal, Function<TaskMonitor, CompletableFuture<T>> futureSupplier) {
        CloseableTaskMonitor monitor = this.publishTask();
        monitor.setCancelEnabled(canCancel);
        CompletableFuture future = futureSupplier.apply(monitor);
        future.handle((t, ex) -> {
            monitor.close();
            return null;
        });
        monitor.addCancelledListener(() -> future.cancel(true));
        return future;
    }
}

