/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.client.SQLEffects;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.elastic.ElasticEffects;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.protocol.FilterAtom;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public class ExecutableCategoryBSimFilterType
extends BSimFilterType {
    public static final String XML_VALUE = "execatmatches";
    private String subType;

    public ExecutableCategoryBSimFilterType(String sub) {
        super(sub + " matches", XML_VALUE, "category value");
        this.subType = sub;
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        super.saveXml(fwrite);
        fwrite.append(" subtype=\"").append(this.subType).append('\"');
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.subType);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof ExecutableCategoryBSimFilterType) {
            ExecutableCategoryBSimFilterType t = (ExecutableCategoryBSimFilterType)obj;
            return Objects.equals(this.subType, t.subType);
        }
        return false;
    }

    @Override
    public void gatherSQLEffect(SQLEffects effect, FilterAtom atom, IDSQLResolution resolution) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("(execattable.id_type=").append(resolution.id1);
        buf.append(" AND execattable.id_category=").append(resolution.id2).append(')');
        effect.addWhere(this, buf.toString());
    }

    @Override
    public void gatherElasticEffect(ElasticEffects effect, FilterAtom atom, IDElasticResolution resolution) throws ElasticException {
        effect.addDocValue("def execat = doc['execategory']; ");
        String argName = effect.assignArgument();
        effect.addScriptElement(this, "Collections.binarySearch(execat,params." + argName + ")>=0");
        effect.addParam(argName, this.subType + "\\t" + atom.value);
    }

    @Override
    public String buildSQLCombinedClause(List<String> subClauses) {
        StringBuilder buf = new StringBuilder();
        buf.append("EXISTS ( SELECT 1 FROM execattable WHERE desctable.id_exe=execattable.id_exe AND (");
        boolean printOr = false;
        for (String clause : subClauses) {
            if (printOr) {
                buf.append(" OR ");
            }
            buf.append(clause);
            printOr = true;
        }
        buf.append(") )");
        return buf.toString();
    }

    @Override
    public boolean evaluate(ExecutableRecord rec, String value) {
        return rec.hasCategory(this.subType, value);
    }

    @Override
    public IDSQLResolution generateIDSQLResolution(FilterAtom atom) {
        return new IDSQLResolution.ExeCategory(this.subType, atom.value);
    }

    @Override
    public boolean orMultipleEntries() {
        return true;
    }
}

