/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import docking.DockingWindowManager;
import docking.widgets.button.BrowseButton;
import docking.widgets.textfield.HintTextField;
import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.filters.BSimValueEditor;
import ghidra.features.bsim.gui.filters.MultiChoiceSelectionDialog;
import ghidra.util.Swing;
import ghidra.util.layout.MiddleLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import utility.function.Callback;

public class MultiChoiceBSimValueEditor
implements BSimValueEditor {
    private BSimFilterType filterType;
    private Callback listener;
    private HintTextField textField;
    private JComponent component;
    private List<String> choices;
    private String dataTitle;
    private boolean isValid;

    public MultiChoiceBSimValueEditor(BSimFilterType filterType, List<String> choices, List<String> initialValues, String dataTitle, Callback listener) {
        this.filterType = filterType;
        this.choices = choices;
        this.dataTitle = dataTitle;
        this.listener = Callback.dummyIfNull((Callback)listener);
        this.component = this.buildComponent();
        this.setValues(initialValues);
        this.checkValid();
    }

    private JComponent buildComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        this.textField = this.createTextField();
        panel.add((Component)this.textField, "Center");
        panel.add((Component)this.buildChooserButton(), "East");
        return panel;
    }

    private JPanel buildChooserButton() {
        JPanel panel = new JPanel((LayoutManager)new MiddleLayout());
        BrowseButton button = new BrowseButton();
        button.addActionListener(e -> this.showChooser());
        panel.add((Component)button);
        return panel;
    }

    private void showChooser() {
        HashSet<String> selected = new HashSet<String>(this.getValues());
        MultiChoiceSelectionDialog<String> dialog = new MultiChoiceSelectionDialog<String>(this.dataTitle, this.choices, selected);
        DockingWindowManager.showDialog(dialog);
        List<String> selectedChoices = dialog.getSelectedChoices();
        if (selectedChoices != null) {
            this.setValues(selectedChoices);
        }
    }

    private HintTextField createTextField() {
        HintTextField hintField = new HintTextField(this.filterType.getHint());
        hintField.setColumns(20);
        hintField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                MultiChoiceBSimValueEditor.this.documentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MultiChoiceBSimValueEditor.this.documentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MultiChoiceBSimValueEditor.this.documentChanged();
            }
        });
        return hintField;
    }

    protected void documentChanged() {
        Swing.runLater(() -> {
            this.checkValid();
            this.listener.call();
        });
    }

    @Override
    public void setValues(List<String> values) {
        if (values == null) {
            this.textField.setText("");
        } else {
            String value = values.stream().collect(Collectors.joining(", "));
            this.textField.setText(value);
        }
    }

    @Override
    public List<String> getValues() {
        String text = this.textField.getText().trim();
        if (text.contains(",")) {
            String[] vals;
            ArrayList<String> values = new ArrayList<String>();
            for (String val : vals = text.split(",")) {
                if (val == null || val.isBlank()) continue;
                values.add(val.trim());
            }
            return values;
        }
        return List.of(text);
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean hasValidValues() {
        return this.isValid;
    }

    private void checkValid() {
        this.isValid = this.checkForValidValues();
        this.textField.setBackground(this.isValid ? VALID_COLOR : INVALID_COLOR);
    }

    private boolean checkForValidValues() {
        List<String> values = this.getValues();
        if (values == null || values.size() == 0) {
            return this.filterType.isValidValue("");
        }
        for (String string : values) {
            if (this.filterType.isValidValue(string)) continue;
            return false;
        }
        return true;
    }
}

