/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import docking.widgets.EmptyBorderButton;
import generic.theme.GThemeDefaults;
import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.search.dialog.BSimFilterSet;
import ghidra.features.bsim.gui.search.dialog.FilterWidget;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import resources.Icons;
import utility.function.Callback;

public class BSimFilterPanel
extends JPanel {
    private JPanel mainPanel;
    private List<BSimFilterType> filters;
    private List<FilterWidget> filterWidgets = new ArrayList<FilterWidget>();
    private Consumer<FilterWidget> removeMeConsumer = this::removeFilterWidget;
    private Callback changeListener;

    public BSimFilterPanel(Callback changeListener) {
        this(List.of(BSimFilterType.BLANK), new BSimFilterSet(), changeListener);
    }

    public BSimFilterPanel(List<BSimFilterType> filters, BSimFilterSet filterSet, Callback changeListener) {
        super(new BorderLayout());
        this.changeListener = changeListener;
        this.mainPanel = new ScrollablePanel();
        JScrollPane scroll = new JScrollPane(this.mainPanel);
        scroll.getViewport().setBackground((Color)GThemeDefaults.Colors.Viewport.UNEDITABLE_BACKGROUND);
        this.add((Component)scroll, "Center");
        this.add(this.buildButtonPanel(), "East");
        this.filters = filters;
        this.setFilterSet(filterSet);
    }

    public void setFilterSet(BSimFilterSet filterSet) {
        this.filterWidgets.removeAll(this.filterWidgets);
        this.mainPanel.removeAll();
        List<BSimFilterSet.FilterEntry> filterEntries = filterSet.getFilterEntries();
        for (BSimFilterSet.FilterEntry filterEntry : filterEntries) {
            FilterWidget widget = new FilterWidget(this.filters, this.removeMeConsumer, this.changeListener);
            widget.setFilter(filterEntry.filterType(), filterEntry.values());
            this.addFilterWidget(widget);
        }
        if (this.filterWidgets.isEmpty()) {
            this.addFilterWidget();
        }
    }

    public void setFilters(List<BSimFilterType> filters) {
        if (filters == null || filters.isEmpty()) {
            filters = List.of(BSimFilterType.BLANK);
        }
        this.filters = filters;
        for (FilterWidget widget : this.filterWidgets) {
            widget.setFilters(this.filters);
        }
    }

    public BSimFilterSet getFilterSet() {
        BSimFilterSet set = new BSimFilterSet();
        for (FilterWidget filter : this.filterWidgets) {
            if (filter.isBlank() || !filter.hasValidValue()) continue;
            set.addEntry(filter.getSelectedFilter(), filter.getValues());
        }
        return set;
    }

    public boolean hasValidFilters() {
        for (FilterWidget filter : this.filterWidgets) {
            if (filter.isBlank() || filter.hasValidValue()) continue;
            return false;
        }
        return true;
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        EmptyBorderButton addFilterButton = new EmptyBorderButton(Icons.ADD_ICON);
        addFilterButton.setToolTipText("Add filter");
        addFilterButton.setName("Add Filter");
        addFilterButton.addActionListener(e -> this.addFilterWidget());
        panel.add((Component)addFilterButton);
        return panel;
    }

    private void addFilterWidget() {
        this.addFilterWidget(new FilterWidget(this.filters, this.removeMeConsumer, this.changeListener));
        this.validate();
    }

    private void addFilterWidget(FilterWidget widget) {
        this.filterWidgets.add(widget);
        this.mainPanel.add(widget);
    }

    private void removeFilterWidget(FilterWidget widget) {
        this.filterWidgets.remove(widget);
        this.mainPanel.remove(widget);
        if (this.mainPanel.getComponentCount() == 0) {
            this.addFilterWidget();
        }
        this.changeListener.call();
        this.validate();
    }

    List<FilterWidget> getFilterWidgets() {
        return this.filterWidgets;
    }

    private class ScrollablePanel
    extends JPanel
    implements Scrollable {
        public ScrollablePanel() {
            super((LayoutManager)new VerticalLayout(5));
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension preferredSize = this.getPreferredSize();
            preferredSize.height = 100;
            return preferredSize;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

