/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import ghidra.features.bsim.gui.search.results.BSimMatchResultsModel;
import ghidra.features.bsim.gui.search.results.BSimResultStatus;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.protocol.BSimFilter;
import ghidra.features.bsim.query.protocol.SimilarityNote;
import ghidra.features.bsim.query.protocol.SimilarityResult;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BSimMatchResult {
    private final FunctionDescription qfunc;
    private final SimilarityNote note;
    private final FunctionDescription matchfunc;
    private final ExecutableRecord matchexe;
    private Address originalAddress;
    private int hashCode;
    private BSimResultStatus status = BSimResultStatus.NOT_APPLIED;

    public BSimMatchResult(FunctionDescription queriedFunction, Address addr, SimilarityNote similarityNote) {
        this.qfunc = queriedFunction;
        this.note = similarityNote;
        this.matchfunc = this.note.getFunctionDescription();
        this.matchexe = this.matchfunc.getExecutableRecord();
        this.originalAddress = addr;
        this.hashCode = 0;
    }

    public boolean isFlagSet(int mask) {
        return (this.matchfunc.getFlags() & mask) != 0;
    }

    public FunctionDescription getOriginalFunctionDescription() {
        return this.qfunc;
    }

    public FunctionDescription getMatchFunctionDescription() {
        return this.matchfunc;
    }

    public Address getAddress() {
        return this.originalAddress;
    }

    public String getExecutableURLString() {
        return this.matchexe.getURLString();
    }

    public BSimResultStatus getStatus() {
        return this.status;
    }

    public void setStatus(BSimResultStatus status) {
        if (status == BSimResultStatus.IGNORED && (this.status == BSimResultStatus.NAME_APPLIED || this.status == BSimResultStatus.SIGNATURE_APPLIED)) {
            return;
        }
        this.status = status;
    }

    public String getOriginalFunctionName() {
        return this.qfunc.getFunctionName();
    }

    public long getOriginalFunctionAddress() {
        return this.qfunc.getAddress();
    }

    public String getExecutableName() {
        return this.matchexe.getNameExec();
    }

    public String getExeCategoryAlphabetic(String type) {
        return this.matchexe.getExeCategoryAlphabetic(type);
    }

    public String getArchitecture() {
        return this.matchexe.getArchitecture();
    }

    public String getCompilerName() {
        return this.matchexe.getNameCompiler();
    }

    public String getMd5() {
        return this.matchexe.getMd5();
    }

    public String getSimilarFunctionName() {
        return this.matchfunc.getFunctionName();
    }

    public long getSimilarFunctionAddress() {
        return this.matchfunc.getAddress();
    }

    public double getSimilarity() {
        return this.note.getSimilarity();
    }

    public double getSignificance() {
        return this.note.getSignificance();
    }

    public Date getDate() {
        return this.matchexe.getDate();
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        String executableMd5 = this.getMd5();
        String originalFunctionName = this.getOriginalFunctionName();
        long origAddr = this.getOriginalFunctionAddress();
        String architecture = this.getArchitecture();
        String similarFunctionName = this.getSimilarFunctionName();
        long similarAddress = this.getSimilarFunctionAddress();
        int prime = 31;
        int result = 1;
        result = prime * result + executableMd5.hashCode();
        result = prime * result + originalFunctionName.hashCode();
        result = prime * result + (int)origAddr;
        result = prime * result + architecture.hashCode();
        result = prime * result + similarFunctionName.hashCode();
        result = prime * result + (int)similarAddress;
        result = prime * result + (int)(origAddr >> 32);
        this.hashCode = result = prime * result + (int)(similarAddress >> 32);
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BSimMatchResult other = (BSimMatchResult)obj;
        if (!this.getMd5().equals(other.getMd5())) {
            return false;
        }
        if (!this.getOriginalFunctionName().equals(other.getOriginalFunctionName())) {
            return false;
        }
        if (this.getOriginalFunctionAddress() != other.getOriginalFunctionAddress()) {
            return false;
        }
        if (!this.getArchitecture().equals(other.getArchitecture())) {
            return false;
        }
        if (!this.getSimilarFunctionName().equals(other.getSimilarFunctionName())) {
            return false;
        }
        return this.getSimilarFunctionAddress() == other.getSimilarFunctionAddress();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.getSimilarFunctionName() + "\n\texecutable: " + this.getExecutableName() + "\n\tsimilarity: " + this.getSimilarity() + "\n\tsignificance: " + this.getSignificance() + "\n\toriginal function: " + this.getOriginalFunctionName();
    }

    public static List<BSimMatchResult> generate(List<SimilarityResult> results, Program prog) {
        ArrayList<BSimMatchResult> resultrows = new ArrayList<BSimMatchResult>();
        for (SimilarityResult result : results) {
            FunctionDescription queriedFunction = result.getBase();
            Address origAddr = BSimMatchResultsModel.recoverAddress(queriedFunction, prog);
            for (SimilarityNote note : result) {
                BSimMatchResult similarFunction = new BSimMatchResult(queriedFunction, origAddr, note);
                resultrows.add(similarFunction);
            }
        }
        return resultrows;
    }

    public static List<BSimMatchResult> filterMatchRows(BSimFilter filter, List<BSimMatchResult> rows) {
        if (filter == null || filter.isEmpty()) {
            return rows;
        }
        ArrayList<BSimMatchResult> filteredrows = new ArrayList<BSimMatchResult>();
        for (BSimMatchResult row : rows) {
            if (!filter.evaluate(row.getMatchFunctionDescription())) continue;
            filteredrows.add(row);
        }
        return filteredrows;
    }
}

