/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import generic.lsh.vector.VectorCompare;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.client.ExecutableScorer;
import ghidra.features.bsim.query.client.ScoreCaching;
import ghidra.features.bsim.query.client.TemporaryScoreCaching;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.VectorResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExecutableScorerSingle
extends ExecutableScorer {
    private float[] singleScore = null;
    private ScoreCaching scoreCache;

    public ExecutableScorerSingle(ScoreCaching cache) throws LSHException {
        this.scoreCache = cache;
        if (this.scoreCache == null) {
            this.scoreCache = new TemporaryScoreCaching();
        }
        this.simThreshold = this.scoreCache.getSimThreshold();
        this.sigThreshold = this.scoreCache.getSigThreshold();
    }

    @Override
    public void setSingleExecutable(String md5) throws LSHException {
        if (this.singleExeXref >= 0) {
            throw new LSHException("Cannot reset singled executable");
        }
        super.setSingleExecutable(md5);
    }

    @Override
    public int countSelfScores() {
        Iterator<ExecutableRecord> iter = this.executableSet.getExecutableRecordSet().iterator();
        int count = 0;
        while (iter.hasNext()) {
            ExecutableRecord exe = iter.next();
            try {
                this.scoreCache.getSelfScore(exe.getMd5());
                ++count;
            }
            catch (LSHException lSHException) {}
        }
        return count;
    }

    @Override
    public void resetStorage(double simThresh, double sigThresh) throws LSHException {
        super.resetStorage(simThresh, sigThresh);
        this.singleScore = null;
        this.scoreCache.resetStorage(simThresh, sigThresh);
    }

    @Override
    public float getSingularSelfScore() {
        return this.singleScore[this.singleExeXref - 1];
    }

    @Override
    protected void initializeScores() {
        int size = this.executableSet.numExecutables();
        this.singleScore = new float[size];
        for (int i = 0; i < size; ++i) {
            this.singleScore[i] = 0.0f;
        }
    }

    @Override
    protected boolean checkPreliminaryPairThreshold(int hitcount, int pairThreshold) {
        return hitcount < pairThreshold;
    }

    @Override
    protected void scorePair(ExecutableScorer.FunctionPair pair) {
        int indexA = pair.funcA.getExecutableRecord().getXrefIndex();
        int indexB = pair.funcB.getExecutableRecord().getXrefIndex();
        if (indexA == this.singleExeXref) {
            int n = indexB - 1;
            this.singleScore[n] = (float)((double)this.singleScore[n] + pair.significance);
        } else if (indexB == this.singleExeXref) {
            int n = indexA - 1;
            this.singleScore[n] = (float)((double)this.singleScore[n] + pair.significance);
        }
    }

    @Override
    protected List<ExecutableScorer.FunctionPair> pairFunctions(LSHVectorFactory vectorFactory, List<DescriptionManager> vec2func, List<VectorResult> vectors, int hitcount, int pairThreshold) {
        ArrayList<FunctionDescription> singleFuncs = new ArrayList<FunctionDescription>(hitcount);
        ArrayList<VectorResult> singleVec = new ArrayList<VectorResult>(hitcount);
        ArrayList<FunctionDescription> otherFuncs = new ArrayList<FunctionDescription>(hitcount);
        ArrayList<VectorResult> otherVec = new ArrayList<VectorResult>(hitcount);
        for (int i = 0; i < vec2func.size(); ++i) {
            DescriptionManager manage = vec2func.get(i);
            VectorResult curVec = vectors.get(i);
            Iterator<FunctionDescription> iter = manage.listAllFunctions();
            while (iter.hasNext()) {
                FunctionDescription func = iter.next();
                int xrefIndex = func.getExecutableRecord().getXrefIndex();
                if (xrefIndex == 0) continue;
                if (xrefIndex == this.singleExeXref) {
                    singleFuncs.add(func);
                    singleVec.add(curVec);
                    continue;
                }
                otherFuncs.add(func);
                otherVec.add(curVec);
            }
        }
        int pairCount = singleFuncs.size() * otherFuncs.size() + singleFuncs.size() * (singleFuncs.size() + 1) / 2;
        if (pairCount > pairThreshold) {
            return null;
        }
        ArrayList<ExecutableScorer.FunctionPair> pairs = new ArrayList<ExecutableScorer.FunctionPair>(pairCount);
        VectorCompare vectorCompare = new VectorCompare();
        for (int i = 0; i < singleFuncs.size(); ++i) {
            LSHVector nextVec;
            int j;
            LSHVector vectorA;
            FunctionDescription funcA = (FunctionDescription)singleFuncs.get(i);
            LSHVector lastVec = vectorA = ((VectorResult)singleVec.get((int)i)).vec;
            double similarity = 1.0;
            double significance = vectorFactory.getSelfSignificance(lastVec);
            for (j = i; j < singleFuncs.size(); ++j) {
                nextVec = ((VectorResult)singleVec.get((int)j)).vec;
                if (lastVec != nextVec) {
                    similarity = vectorA.compare(nextVec, vectorCompare);
                    significance = vectorFactory.calculateSignificance(vectorCompare);
                    lastVec = nextVec;
                }
                if (similarity < this.simThreshold || significance < this.sigThreshold) continue;
                pairs.add(new ExecutableScorer.FunctionPair(funcA, (FunctionDescription)singleFuncs.get(j), similarity, significance));
            }
            for (j = 0; j < otherFuncs.size(); ++j) {
                nextVec = ((VectorResult)otherVec.get((int)j)).vec;
                if (lastVec != nextVec) {
                    similarity = vectorA.compare(nextVec, vectorCompare);
                    significance = vectorFactory.calculateSignificance(vectorCompare);
                    lastVec = nextVec;
                }
                if (similarity < this.simThreshold || significance < this.sigThreshold) continue;
                FunctionDescription funcB = (FunctionDescription)otherFuncs.get(j);
                pairs.add(new ExecutableScorer.FunctionPair(funcA, funcB, similarity, significance));
            }
        }
        return pairs;
    }

    @Override
    public float getScore(int a) {
        return this.singleScore[a - 1];
    }

    @Override
    public float getSelfScore(int a) throws LSHException {
        if (a == this.singleExeXref) {
            return this.singleScore[a - 1];
        }
        ExecutableRecord executableRecord = (ExecutableRecord)this.index2ExeMap.get(a);
        if (executableRecord == null) {
            return 0.0f;
        }
        return this.scoreCache.getSelfScore(executableRecord.getMd5());
    }

    @Override
    public void commitSelfScore() throws LSHException {
        this.scoreCache.commitSelfScore(this.singleExe.getMd5(), this.singleScore[this.singleExeXref - 1]);
    }

    @Override
    protected void commitSelfScore(String md5, float selfScore) throws LSHException {
        this.scoreCache.commitSelfScore(md5, selfScore);
    }

    @Override
    public float getScore(int a, int b) {
        if (b == this.singleExeXref) {
            return this.singleScore[a - 1];
        }
        return this.singleScore[b - 1];
    }

    public void prefetchSelfScores(List<ExecutableRecord> missing) throws LSHException {
        this.scoreCache.prefetchScores(this.executableSet.getExecutableRecordSet(), missing);
    }
}

