/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.client.ScoreCaching;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.protocol.InsertOptionalValues;
import ghidra.features.bsim.query.protocol.QueryOptionalExist;
import ghidra.features.bsim.query.protocol.QueryOptionalValues;
import ghidra.features.bsim.query.protocol.ResponseOptionalExist;
import ghidra.features.bsim.query.protocol.ResponseOptionalValues;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class TableScoreCaching
implements ScoreCaching {
    private static final String TABLE_NAME = "exeselfscores";
    private static final String SIMILARITY_KEY = "similarity";
    private static final String SIGNIFICANCE_KEY = "significance";
    private static final int VALUES_PER_QUERY = 100;
    private FunctionDatabase db;
    private TreeMap<String, Float> cacheMap;
    private double simThreshold;
    private double sigThreshold;
    private QueryOptionalValues queryValue;
    private InsertOptionalValues insertValue;

    public TableScoreCaching(FunctionDatabase d) {
        this.db = d;
        this.cacheMap = null;
        this.simThreshold = -1.0;
        this.sigThreshold = -1.0;
        this.queryValue = new QueryOptionalValues();
        this.queryValue.tableName = TABLE_NAME;
        this.queryValue.keyType = 12;
        this.queryValue.valueType = 7;
        this.queryValue.keys = new Object[1];
        this.insertValue = new InsertOptionalValues();
        this.insertValue.tableName = TABLE_NAME;
        this.insertValue.keyType = 12;
        this.insertValue.valueType = 7;
        this.insertValue.keys = new Object[1];
        this.insertValue.values = new Object[1];
    }

    private void setUpQuery(int size) {
        if (this.queryValue != null && this.queryValue.keys.length == size) {
            return;
        }
        this.queryValue.keys = new Object[size];
    }

    private void setUpInsert(int size) {
        if (this.insertValue != null && this.insertValue.keys.length == size) {
            return;
        }
        this.insertValue.keys = new Object[size];
        this.insertValue.values = new Object[size];
    }

    private void initialize() throws LSHException {
        if (this.cacheMap != null) {
            return;
        }
        this.cacheMap = new TreeMap();
        QueryOptionalExist query = new QueryOptionalExist();
        query.tableName = TABLE_NAME;
        query.keyType = 12;
        query.valueType = 7;
        query.attemptCreation = true;
        ResponseOptionalExist response = (ResponseOptionalExist)query.execute(this.db);
        if (response == null) {
            throw new LSHException(this.db.getLastError().message);
        }
        if (response.wasCreated) {
            return;
        }
        this.setUpQuery(2);
        this.queryValue.keys[0] = SIMILARITY_KEY;
        this.queryValue.keys[1] = SIGNIFICANCE_KEY;
        ResponseOptionalValues optionalresponse = (ResponseOptionalValues)this.queryValue.execute(this.db);
        if (optionalresponse == null) {
            throw new LSHException(this.db.getLastError().message);
        }
        Float simObj = (Float)optionalresponse.resultArray[0];
        Float sigObj = (Float)optionalresponse.resultArray[1];
        if (simObj != null && sigObj != null) {
            this.simThreshold = simObj.doubleValue();
            this.sigThreshold = sigObj.doubleValue();
        }
    }

    @Override
    public void prefetchScores(Set<ExecutableRecord> exeSet, List<ExecutableRecord> missing) throws LSHException {
        int curSize;
        this.initialize();
        Iterator<ExecutableRecord> iter = exeSet.iterator();
        ExecutableRecord[] queryGroup = new ExecutableRecord[100];
        for (int size = exeSet.size(); size > 0; size -= curSize) {
            curSize = size > 100 ? 100 : size;
            this.setUpQuery(curSize);
            for (int i = 0; i < curSize; ++i) {
                queryGroup[i] = iter.next();
                this.queryValue.keys[i] = queryGroup[i].getMd5();
            }
            ResponseOptionalValues response = (ResponseOptionalValues)this.queryValue.execute(this.db);
            if (response == null) {
                throw new LSHException(this.db.getLastError().message);
            }
            Object[] result = response.resultArray;
            for (int i = 0; i < curSize; ++i) {
                if (result[i] != null) {
                    this.cacheMap.put((String)this.queryValue.keys[i], (Float)result[i]);
                    continue;
                }
                if (missing == null) continue;
                missing.add(queryGroup[i]);
            }
        }
    }

    @Override
    public float getSelfScore(String md5) throws LSHException {
        this.initialize();
        Float val = this.cacheMap.get(md5);
        if (val != null) {
            return val.floatValue();
        }
        this.setUpQuery(1);
        this.queryValue.keys[0] = md5;
        ResponseOptionalValues response = (ResponseOptionalValues)this.queryValue.execute(this.db);
        if (response == null) {
            throw new LSHException(this.db.getLastError().message);
        }
        val = (Float)response.resultArray[0];
        if (val == null) {
            throw new LSHException("Self-score not recorded for " + md5);
        }
        this.cacheMap.put(md5, val);
        return val.floatValue();
    }

    @Override
    public void commitSelfScore(String md5, float score) throws LSHException {
        this.initialize();
        Float val = Float.valueOf(score);
        this.cacheMap.put(md5, val);
        this.setUpInsert(1);
        this.insertValue.keys[0] = md5;
        this.insertValue.values[0] = val;
        ResponseOptionalExist response = (ResponseOptionalExist)this.insertValue.execute(this.db);
        if (response == null) {
            throw new LSHException(this.db.getLastError().message);
        }
    }

    @Override
    public double getSimThreshold() throws LSHException {
        this.initialize();
        return this.simThreshold;
    }

    @Override
    public double getSigThreshold() throws LSHException {
        this.initialize();
        return this.sigThreshold;
    }

    @Override
    public void resetStorage(double simThresh, double sigThresh) throws LSHException {
        this.simThreshold = simThresh;
        this.sigThreshold = sigThresh;
        this.cacheMap = new TreeMap();
        QueryOptionalExist query = new QueryOptionalExist();
        query.tableName = TABLE_NAME;
        query.keyType = 12;
        query.valueType = 7;
        query.attemptCreation = false;
        query.clearTable = true;
        ResponseOptionalExist response = (ResponseOptionalExist)query.execute(this.db);
        if (response == null) {
            throw new LSHException(this.db.getLastError().message);
        }
        if (!response.tableExists) {
            throw new LSHException("Optional table does not exist when it should: exeselfscores");
        }
        this.setUpInsert(2);
        this.insertValue.keys[0] = SIMILARITY_KEY;
        this.insertValue.keys[1] = SIGNIFICANCE_KEY;
        this.insertValue.values[0] = Float.valueOf((float)this.simThreshold);
        this.insertValue.values[1] = Float.valueOf((float)this.sigThreshold);
        if (this.insertValue.execute(this.db) == null) {
            throw new LSHException("Unable to initialize new thresholds: exeselfscores");
        }
    }
}

