/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponsePassword;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class PasswordChange
extends BSimQuery<ResponsePassword> {
    public ResponsePassword passwordResponse;
    public String username = null;
    public char[] newPassword = null;

    public PasswordChange() {
        super("passwordchange");
    }

    public void clearPassword() {
        if (this.newPassword != null) {
            for (int i = 0; i < this.newPassword.length; ++i) {
                this.newPassword[i] = 32;
            }
        }
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.passwordResponse = new ResponsePassword();
            this.response = this.passwordResponse;
        }
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append("<").append(this.name);
        fwrite.append(" username=\"").append(this.username);
        fwrite.append("\">");
        SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)new String(this.newPassword));
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        XmlElement el = parser.start(new String[]{this.name});
        this.username = el.getAttribute("username");
        this.newPassword = parser.end().getText().toCharArray();
    }
}

