/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.transform.MutableAffineTransformer;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.transform.shape.ShapeTransformer;
import org.jungrapht.visualization.util.ChangeEventSupport;
import org.jungrapht.visualization.util.DefaultChangeEventSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransformer
implements MultiLayerTransformer,
ShapeTransformer,
ChangeListener,
ChangeEventSupport {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransformer.class);
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    protected MutableTransformer viewTransformer = new MutableAffineTransformer(new AffineTransform());
    protected MutableTransformer layoutTransformer = new MutableAffineTransformer(new AffineTransform());

    public DefaultTransformer() {
        this.viewTransformer.addChangeListener(this);
        this.layoutTransformer.addChangeListener(this);
    }

    protected void setViewTransformer(MutableTransformer Function2) {
        this.viewTransformer.removeChangeListener(this);
        this.viewTransformer = Function2;
        this.viewTransformer.addChangeListener(this);
    }

    protected void setLayoutTransformer(MutableTransformer Function2) {
        this.layoutTransformer.removeChangeListener(this);
        this.layoutTransformer = Function2;
        this.layoutTransformer.addChangeListener(this);
    }

    protected MutableTransformer getLayoutTransformer() {
        return this.layoutTransformer;
    }

    protected MutableTransformer getViewTransformer() {
        return this.viewTransformer;
    }

    @Override
    public Point2D inverseTransform(Point2D p) {
        return this.inverseLayoutTransform(this.inverseViewTransform(p));
    }

    @Override
    public Point2D inverseTransform(double x, double y) {
        return this.inverseTransform(new Point2D.Double(x, y));
    }

    protected Point2D inverseViewTransform(Point2D p) {
        return this.viewTransformer.inverseTransform(p);
    }

    protected Point2D inverseLayoutTransform(Point2D p) {
        return this.layoutTransformer.inverseTransform(p);
    }

    @Override
    public Point2D transform(Point2D p) {
        return this.viewTransform(this.layoutTransform(p));
    }

    @Override
    public Point2D transform(double x, double y) {
        return this.transform(new Point2D.Double(x, y));
    }

    protected Point2D viewTransform(Point2D p) {
        return this.viewTransformer.transform(p);
    }

    protected Point2D layoutTransform(Point2D p) {
        return this.layoutTransformer.transform(p);
    }

    @Override
    public Shape inverseTransform(Shape shape) {
        return this.inverseLayoutTransform(this.inverseViewTransform(shape));
    }

    protected Shape inverseViewTransform(Shape shape) {
        return this.viewTransformer.inverseTransform(shape);
    }

    protected Shape inverseLayoutTransform(Shape shape) {
        return this.layoutTransformer.inverseTransform(shape);
    }

    @Override
    public Shape transform(Shape shape) {
        return this.viewTransform(this.layoutTransform(shape));
    }

    protected Shape viewTransform(Shape shape) {
        return this.viewTransformer.transform(shape);
    }

    protected Shape layoutTransform(Shape shape) {
        return this.layoutTransformer.transform(shape);
    }

    @Override
    public void setToIdentity() {
        this.layoutTransformer.setToIdentity();
        this.viewTransformer.setToIdentity();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    @Override
    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireStateChanged();
    }

    @Override
    public MutableTransformer getTransformer(MultiLayerTransformer.Layer layer) {
        if (layer == MultiLayerTransformer.Layer.LAYOUT) {
            return this.layoutTransformer;
        }
        if (layer == MultiLayerTransformer.Layer.VIEW) {
            return this.viewTransformer;
        }
        return null;
    }

    @Override
    public Point2D inverseTransform(MultiLayerTransformer.Layer layer, Point2D p) {
        if (layer == MultiLayerTransformer.Layer.LAYOUT) {
            return this.inverseLayoutTransform(p);
        }
        if (layer == MultiLayerTransformer.Layer.VIEW) {
            return this.inverseViewTransform(p);
        }
        return null;
    }

    @Override
    public Point2D inverseTransform(MultiLayerTransformer.Layer layer, double x, double y) {
        return this.inverseTransform(layer, new Point2D.Double(x, y));
    }

    @Override
    public void setTransformer(MultiLayerTransformer.Layer layer, MutableTransformer Function2) {
        if (layer == MultiLayerTransformer.Layer.LAYOUT) {
            this.setLayoutTransformer(Function2);
        }
        if (layer == MultiLayerTransformer.Layer.VIEW) {
            this.setViewTransformer(Function2);
        }
    }

    @Override
    public Point2D transform(MultiLayerTransformer.Layer layer, Point2D p) {
        if (layer == MultiLayerTransformer.Layer.LAYOUT) {
            return this.layoutTransform(p);
        }
        if (layer == MultiLayerTransformer.Layer.VIEW) {
            return this.viewTransform(p);
        }
        return null;
    }

    @Override
    public Point2D transform(MultiLayerTransformer.Layer layer, double x, double y) {
        return this.transform(layer, new Point2D.Double(x, y));
    }

    @Override
    public Shape transform(MultiLayerTransformer.Layer layer, Shape shape) {
        if (log.isTraceEnabled()) {
            log.trace("transform {} {}", (Object)layer, (Object)shape);
        }
        if (layer == MultiLayerTransformer.Layer.LAYOUT) {
            return this.layoutTransform(shape);
        }
        if (layer == MultiLayerTransformer.Layer.VIEW) {
            return this.viewTransform(shape);
        }
        return null;
    }

    @Override
    public Shape inverseTransform(MultiLayerTransformer.Layer layer, Shape shape) {
        if (log.isTraceEnabled()) {
            log.trace("inverseTransform {} {}", (Object)layer, (Object)shape);
        }
        if (layer == MultiLayerTransformer.Layer.LAYOUT) {
            return this.inverseLayoutTransform(shape);
        }
        if (layer == MultiLayerTransformer.Layer.VIEW) {
            return this.inverseViewTransform(shape);
        }
        return null;
    }
}

