/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.LayoutScalingControl;
import org.jungrapht.visualization.control.Modifiers;
import org.jungrapht.visualization.control.ScalingControl;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.selection.ShapePickSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseWheelListener,
MouseListener {
    private static final Logger log = LoggerFactory.getLogger(ScalingGraphMousePlugin.class);
    private static final String PICK_AREA_SIZE = "jungrapht.pickAreaSize";
    protected int pickSize = Integer.getInteger("jungrapht.pickAreaSize", 4);
    private static String ENABLE_MIDDLE_MOUSE_BUTTON_SCALE_RESET;
    private static String ENABLE_DOUBLE_CLICK_SCALE_RESET;
    protected float in = 1.1f;
    protected float out = 0.9090909f;
    protected int scalingMask;
    protected int xAxisScalingMask;
    protected int yAxisScalingMask;
    protected boolean zoomAtMouse = true;
    protected ScalingControl scaler;
    protected ScalingControl layoutScalingControl = new LayoutScalingControl();
    protected boolean enableMiddleMouseButtonScaleReset = Boolean.parseBoolean(System.getProperty(ENABLE_MIDDLE_MOUSE_BUTTON_SCALE_RESET, "true"));
    protected boolean enableDoubleClickScaleReset = Boolean.parseBoolean(System.getProperty(ENABLE_DOUBLE_CLICK_SCALE_RESET, "true"));

    public static Builder builder() {
        return new Builder();
    }

    public ScalingGraphMousePlugin() {
        this(ScalingGraphMousePlugin.builder());
    }

    public ScalingGraphMousePlugin(Builder builder) {
        this(builder.scalingControl, builder.scalingMask, builder.xAxisScalingMask, builder.yAxisScalingMask);
    }

    public ScalingGraphMousePlugin(ScalingControl scaler, int scalingMask, int xAxisScalingMask, int yAxisScalingMask) {
        this(scaler, scalingMask, xAxisScalingMask, yAxisScalingMask, 1.1f, 0.9090909f);
    }

    public ScalingGraphMousePlugin(ScalingControl scaler, int scalingMask, int xAxisScalingMask, int yAxisScalingMask, float in, float out) {
        this.scaler = scaler;
        this.scalingMask = scalingMask;
        this.xAxisScalingMask = xAxisScalingMask;
        this.yAxisScalingMask = yAxisScalingMask;
        this.in = in;
        this.out = out;
    }

    public void setZoomAtMouse(boolean zoomAtMouse) {
        this.zoomAtMouse = zoomAtMouse;
    }

    @Override
    public boolean checkModifiers(MouseEvent e) {
        return e.getModifiersEx() == this.scalingMask || e.getModifiersEx() == this.xAxisScalingMask || e.getModifiersEx() == this.yAxisScalingMask;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            ScalingControl scalingControl = this.scaler;
            float xin = this.in;
            float yin = this.in;
            float xout = this.out;
            float yout = this.out;
            if (e.getModifiersEx() == this.xAxisScalingMask) {
                yout = 1.0f;
                yin = 1.0f;
                scalingControl = this.layoutScalingControl;
            }
            if (e.getModifiersEx() == this.yAxisScalingMask) {
                xout = 1.0f;
                xin = 1.0f;
                scalingControl = this.layoutScalingControl;
            }
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point mouse = e.getPoint();
            int amount = e.getWheelRotation();
            if (this.zoomAtMouse) {
                if (amount < 0) {
                    scalingControl.scale(vv, xin, yin, mouse);
                } else if (amount > 0) {
                    scalingControl.scale(vv, xout, yout, mouse);
                }
            } else {
                Point2D center = vv.getCenter();
                if (amount < 0) {
                    scalingControl.scale(vv, xin, yin, center);
                } else if (amount > 0) {
                    scalingControl.scale(vv, xout, yout, center);
                }
            }
            e.consume();
            vv.repaint();
        }
    }

    public float getIn() {
        return this.in;
    }

    public void setIn(float in) {
        this.in = in;
    }

    public float getOut() {
        return this.out;
    }

    public void setOut(float out) {
        this.out = out;
    }

    public ScalingControl getScaler() {
        return this.scaler;
    }

    public void setScaler(ScalingControl scaler) {
        this.scaler = scaler;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        log.trace("mouseClicked {} in {}", (Object)e.getClickCount(), (Object)this.getClass().getName());
        if (this.enableDoubleClickScaleReset && e.getClickCount() == 2 && this.scaler instanceof CrossoverScalingControl && !this.singleVertexSelection(e) && !this.singleEdgeSelection(e)) {
            CrossoverScalingControl crossoverScalingControl = (CrossoverScalingControl)this.scaler;
            crossoverScalingControl.reset((VisualizationServer)e.getSource(), e.getPoint());
            ((VisualizationViewer)e.getSource()).scaleToLayout(this.scaler);
            e.consume();
        }
    }

    protected <V, E> boolean singleVertexSelection(MouseEvent e) {
        Object vertex;
        VisualizationServer vv = (VisualizationServer)e.getSource();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
        TransformSupport transformSupport = vv.getTransformSupport();
        Point2D layoutPoint = transformSupport.inverseTransform(vv, e.getPoint());
        Rectangle2D.Float footprintRectangle = new Rectangle2D.Float((float)e.getPoint().x - (float)(this.pickSize / 2), (float)e.getPoint().y - (float)(this.pickSize / 2), this.pickSize, this.pickSize);
        if (pickSupport instanceof ShapePickSupport) {
            ShapePickSupport shapePickSupport = (ShapePickSupport)pickSupport;
            vertex = shapePickSupport.getVertex(layoutModel, footprintRectangle);
        } else {
            vertex = pickSupport.getVertex(layoutModel, layoutPoint.getX(), layoutPoint.getY());
        }
        return vertex != null;
    }

    protected <V, E> boolean singleEdgeSelection(MouseEvent e) {
        Object edge;
        VisualizationServer vv = (VisualizationServer)e.getSource();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
        TransformSupport transformSupport = vv.getTransformSupport();
        Point2D layoutPoint = transformSupport.inverseTransform(vv, e.getPoint());
        Rectangle2D.Float footprintRectangle = new Rectangle2D.Float((float)e.getPoint().x - (float)(this.pickSize / 2), (float)e.getPoint().y - (float)(this.pickSize / 2), this.pickSize, this.pickSize);
        if (pickSupport instanceof ShapePickSupport) {
            ShapePickSupport shapePickSupport = (ShapePickSupport)pickSupport;
            edge = shapePickSupport.getEdge(layoutModel, footprintRectangle);
        } else {
            edge = pickSupport.getEdge(layoutModel, layoutPoint.getX(), layoutPoint.getY());
        }
        return edge != null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        log.trace("mousePressed in {}", (Object)this.getClass().getName());
        if (this.enableMiddleMouseButtonScaleReset && e.getModifiersEx() == 2048 && this.scaler instanceof CrossoverScalingControl) {
            CrossoverScalingControl crossoverScalingControl = (CrossoverScalingControl)this.scaler;
            crossoverScalingControl.reset((VisualizationServer)e.getSource(), e.getPoint());
            ((VisualizationViewer)e.getSource()).scaleToLayout(this.scaler);
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static {
        PropertyLoader.load();
        ENABLE_MIDDLE_MOUSE_BUTTON_SCALE_RESET = "jungrapht.enableMiddleMouseButtonScaleReset";
        ENABLE_DOUBLE_CLICK_SCALE_RESET = "jungrapht.enableDoubleClickScaleReset";
    }

    public static class Builder {
        ScalingControl scalingControl = new CrossoverScalingControl();
        protected int xAxisScalingMask = Modifiers.masks.get(System.getProperty("jungrapht.xAxisScalingMask", "MENU"));
        protected int yAxisScalingMask = Modifiers.masks.get(System.getProperty("jungrapht.yAxisScalingMask", "ALT"));
        protected int scalingMask = Modifiers.masks.get(System.getProperty("jungrapht.scalingMask", "NONE"));

        public Builder self() {
            return this;
        }

        public Builder scalingControl(ScalingControl scalingControl) {
            this.scalingControl = scalingControl;
            return this.self();
        }

        public Builder scalingMask(int scalingMask) {
            this.scalingMask = scalingMask;
            return this.self();
        }

        public Builder xAxisScalingMask(int xAxisScalingMask) {
            this.xAxisScalingMask = xAxisScalingMask;
            return this.self();
        }

        public Builder yAxisScalingMask(int yAxisScalingMask) {
            this.yAxisScalingMask = yAxisScalingMask;
            return this.self();
        }

        public ScalingGraphMousePlugin build() {
            return new ScalingGraphMousePlugin(this);
        }
    }
}

