/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.spatial.rtree;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jungrapht.visualization.spatial.rtree.Bounded;
import org.jungrapht.visualization.spatial.rtree.BoundedList;
import org.jungrapht.visualization.spatial.rtree.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeList<B extends Bounded>
extends ArrayList<B>
implements BoundedList<B>,
Bounded {
    private static final Logger log = LoggerFactory.getLogger(NodeList.class);
    private Rectangle2D bounds;

    public NodeList() {
    }

    public NodeList(int initialCapacity) {
        super(initialCapacity);
    }

    public NodeList(Collection<B> list) {
        this.addAll((Collection<? extends B>)list);
    }

    public NodeList(B ... nodes) {
        this.addAll((Collection<? extends B>)Arrays.asList(nodes));
    }

    @Override
    public boolean add(B n) {
        if (n instanceof Node) {
            Node node = (Node)n;
            if (node.getParent() == null || node.getParent().isEmpty()) {
                log.error("adding a node {} with unset parent {}", (Object)node, node.getParent());
            }
        } else {
            log.error("adding something that is not a Node: {}", n);
        }
        this.addBoundsFor(n);
        return super.add(n);
    }

    @Override
    public void add(int index, B element) {
        this.addBoundsFor(element);
        super.add(index, element);
    }

    @Override
    public B remove(int index) {
        Bounded removed = (Bounded)super.remove(index);
        this.recalculateBounds();
        return (B)removed;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = super.remove(o);
        this.recalculateBounds();
        return removed;
    }

    @Override
    public void clear() {
        super.clear();
        this.bounds = null;
    }

    @Override
    public boolean addAll(Collection<? extends B> c) {
        this.addBoundsFor((B)c);
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends B> c) {
        return super.addAll(index, c);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    private void addBoundsFor(Collection<? extends B> kids) {
        for (Bounded kid : kids) {
            this.addBoundsFor(kid);
        }
    }

    private void addBoundsFor(B kid) {
        this.bounds = this.bounds == null ? kid.getBounds() : this.bounds.createUnion(kid.getBounds());
    }

    @Override
    public void recalculateBounds() {
        this.bounds = null;
        for (Bounded n : this) {
            this.addBoundsFor(n);
        }
    }
}

