/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.transform;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lens {
    private static final Logger log = LoggerFactory.getLogger(Lens.class);
    protected RectangularShape lensShape;
    protected float magnification;

    public static Builder builder(Shape lensShape) {
        return new Builder(lensShape);
    }

    public static Builder builder() {
        return new Builder(Shape.ELLIPSE);
    }

    public Lens() {
        this(Lens.builder());
    }

    private Lens(Builder builder) {
        this.lensShape = builder.lensShape;
        this.magnification = builder.magnification;
    }

    public float getMagnification() {
        return this.magnification;
    }

    public void setMagnification(float magnification) {
        log.trace("setmagnification to {}", (Object)Float.valueOf(magnification));
        this.magnification = magnification;
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.lensShape.getCenterX(), this.lensShape.getCenterY());
    }

    public void setCenter(Point2D viewCenter) {
        double width = this.lensShape.getWidth();
        double height = this.lensShape.getHeight();
        this.lensShape.setFrame(viewCenter.getX() - width / 2.0, viewCenter.getY() - height / 2.0, width, height);
        log.trace("setCenter of lens {} to {}", (Object)this.lensShape, (Object)viewCenter);
    }

    public double getRadius() {
        return this.lensShape.getHeight() / 2.0;
    }

    public double getCenterToCorner() {
        double w = this.lensShape.getWidth();
        double h = this.lensShape.getHeight();
        double diag = Math.sqrt(w * w + h * h);
        return diag / 2.0;
    }

    public void setRadius(double viewRadius) {
        double x = this.lensShape.getCenterX();
        double y = this.lensShape.getCenterY();
        double viewRatio = this.getRatio();
        this.lensShape.setFrame(x - viewRadius / viewRatio, y - viewRadius, 2.0 * viewRadius / viewRatio, 2.0 * viewRadius);
        log.trace("setRadius of lens {} to {}", (Object)this, (Object)viewRadius);
    }

    public double getRatio() {
        if (this.lensShape.getWidth() == 0.0) {
            return 1.0;
        }
        return this.lensShape.getHeight() / this.lensShape.getWidth();
    }

    public void setLensShape(RectangularShape ellipse) {
        log.trace("setLensShape to {}", (Object)ellipse);
        this.lensShape = ellipse;
    }

    public RectangularShape getLensShape() {
        return this.lensShape;
    }

    public double getDistanceFromCenter(Point2D p) {
        double dx = this.lensShape.getCenterX() - p.getX();
        double dy = this.lensShape.getCenterY() - p.getY();
        return Math.sqrt((dx *= this.getRatio()) * dx + dy * dy);
    }

    public static class Builder {
        private RectangularShape lensShape = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        private float magnification = 0.7f;

        private Builder(Shape lensShape) {
            this.setShapeFrom(lensShape);
        }

        private void setShapeFrom(Shape lensShape) {
            switch (lensShape) {
                case RECTANGLE: {
                    this.lensShape = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
                    break;
                }
                default: {
                    this.lensShape = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
                }
            }
        }

        public Builder lensShape(Shape shape) {
            this.setShapeFrom(shape);
            return this;
        }

        public Builder magnification(float magnification) {
            this.magnification = magnification;
            return this;
        }

        public Lens build() {
            return new Lens(this);
        }
    }

    public static enum Shape {
        ELLIPSE,
        RECTANGLE;

    }
}

