/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class IconFunction<V>
implements Function<V, Icon> {
    Map<V, Icon> iconMap = new HashMap<V, Icon>();
    Function<V, String> vertexLabelFunction;
    JLabel stamp = new JLabel();
    Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();

    public IconFunction(Function<V, String> vertexLabelFunction) {
        this.vertexLabelFunction = vertexLabelFunction;
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    @Override
    public Icon apply(V n) {
        if (!this.iconMap.containsKey(n)) {
            this.cacheIconFor(n);
        }
        return this.iconMap.get(n);
    }

    private void cacheIconFor(V vertex) {
        this.stamp.setText(this.vertexLabelFunction.apply(vertex));
        this.stamp.setForeground(Color.black);
        this.stamp.setBackground(Color.white);
        this.stamp.setOpaque(true);
        this.stamp.setSize(this.stamp.getPreferredSize());
        this.stamp.addNotify();
        BufferedImage bi = new BufferedImage(this.stamp.getWidth(), this.stamp.getHeight(), 1);
        Graphics2D graphics = bi.createGraphics();
        graphics.setRenderingHints(this.renderingHints);
        this.stamp.paint(graphics);
        graphics.setPaint(Color.black);
        graphics.drawRect(0, 0, this.stamp.getWidth() - 1, this.stamp.getHeight() - 1);
        graphics.dispose();
        ImageIcon icon = new ImageIcon(bi);
        this.iconMap.put((Icon)vertex, icon);
    }
}

