/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data.ISF;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public abstract class AbstractIsfWriter
implements Closeable {
    protected JsonWriter writer;
    protected Gson gson = new GsonBuilder().setPrettyPrinting().create();
    protected JsonObject root = new JsonObject();
    protected JsonArray objects = new JsonArray();
    protected boolean STRICT = true;
    ExclusionStrategy strategy = new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            return AbstractIsfWriter.this.STRICT && field.getAnnotation(Exclude.class) != null;
        }
    };

    public AbstractIsfWriter(Writer baseWriter) throws IOException {
        if (baseWriter != null) {
            this.writer = new JsonWriter(baseWriter);
            this.writer.setIndent("  ");
        }
        this.gson = new GsonBuilder().addSerializationExclusionStrategy(this.strategy).setPrettyPrinting().create();
    }

    protected abstract void genRoot(TaskMonitor var1) throws CancelledException, IOException;

    public JsonObject getRootObject(TaskMonitor monitor) throws CancelledException, IOException {
        this.genRoot(monitor);
        return this.root;
    }

    public JsonArray getResults() {
        return this.objects;
    }

    public JsonElement getTree(Object obj) {
        return this.gson.toJsonTree(obj);
    }

    public Object getObject(JsonElement element, Class<? extends Object> clazz) {
        return this.gson.fromJson(element, clazz);
    }

    public void write(JsonObject object) {
        this.gson.toJson((JsonElement)object, this.writer);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Exclude {
    }
}

