/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.catacombae.dmgextractor.io.ByteCountInputStream;
import org.catacombae.dmgextractor.io.CharByCharReader;
import org.catacombae.dmgextractor.io.RandomAccessInputStream;
import org.catacombae.dmgextractor.io.SynchronizedRandomAccessStream;
import org.catacombae.xml.XMLElement;

public class XMLText
extends XMLElement {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char TAB = '\t';
    private final String text;
    private int beginLine = -1;
    private int beginColumn = -1;
    private int endLine = -1;
    private int endColumn = -1;
    private long beginOffset;
    private long endOffset;
    private final SynchronizedRandomAccessStream xmlFile;
    private Charset encoding;

    public XMLText(String text) {
        this.text = text;
        this.xmlFile = null;
    }

    public XMLText(SynchronizedRandomAccessStream xmlFile, Charset encoding, long beginOffset, long endOffset) {
        this.text = null;
        this.xmlFile = xmlFile;
        this.encoding = encoding;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    public XMLText(SynchronizedRandomAccessStream xmlFile, Charset encoding, int beginLine, int beginColumn, int endLine, int endColumn) {
        this(xmlFile, encoding, -1L, -1L);
        if (endLine < beginLine || endLine == beginLine && endColumn < beginColumn) {
            throw new IllegalArgumentException("negative interval length");
        }
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public Reader getText() throws IOException {
        if (this.text == null) {
            if (this.beginOffset == -1L && this.endOffset == -1L) {
                this.calculateOffsets();
            }
            return new InputStreamReader((InputStream)new RandomAccessInputStream(this.xmlFile, this.beginOffset, this.endOffset - this.beginOffset), this.encoding);
        }
        return new StringReader(this.text);
    }

    private void calculateOffsets() throws IOException {
        ByteCountInputStream bcis = new ByteCountInputStream(new BufferedInputStream(new RandomAccessInputStream(this.xmlFile)));
        CharByCharReader lnr = new CharByCharReader(bcis, this.encoding);
        boolean previousCR = false;
        long lineNumber = 1L;
        long colNumber = -1L;
        int currentChar = 0;
        while (currentChar >= 0) {
            char c = (char)currentChar;
            boolean lfskip = false;
            if (c == '\r') {
                ++lineNumber;
                previousCR = true;
            } else if (c == '\n') {
                if (!previousCR) {
                    ++lineNumber;
                    colNumber = 0L;
                } else {
                    previousCR = false;
                    lfskip = true;
                }
            } else if (c == '\t') {
                colNumber += 8L;
                previousCR = false;
            } else {
                ++colNumber;
                previousCR = false;
            }
            if (!lfskip) {
                if (lineNumber == (long)this.beginLine && colNumber == (long)this.beginColumn) {
                    this.beginOffset = bcis.getBytesRead() - 1L;
                }
                if (lineNumber == (long)this.endLine && colNumber == (long)this.endColumn) {
                    this.endOffset = bcis.getBytesRead();
                    break;
                }
            }
            currentChar = lnr.read();
        }
        if (this.beginOffset == -1L || this.endOffset == -1L) {
            throw new RuntimeException("Could not find the requested interval! (begin: (" + this.beginLine + "," + this.beginColumn + ") end: (" + this.endLine + "," + this.endColumn + "))");
        }
    }

    protected void _printTree(PrintStream pw, int level) {
        for (int i = 0; i < level; ++i) {
            pw.print(" ");
        }
        pw.println(this.text.toString());
    }
}

